/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.Date;
import twitter4j.DirectMessage;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.RateLimitStatus;
import twitter4j.SymbolEntity;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyDirectMessage
implements DirectMessage {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private DirectMessage target = null;

    LazyDirectMessage(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private DirectMessage getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createDirectMessage(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public long getId() {
        return this.getTarget().getId();
    }

    public String getText() {
        return this.getTarget().getText();
    }

    public long getSenderId() {
        return this.getTarget().getSenderId();
    }

    public long getRecipientId() {
        return this.getTarget().getRecipientId();
    }

    public Date getCreatedAt() {
        return this.getTarget().getCreatedAt();
    }

    public String getSenderScreenName() {
        return this.getTarget().getSenderScreenName();
    }

    public String getRecipientScreenName() {
        return this.getTarget().getRecipientScreenName();
    }

    public User getSender() {
        return this.getTarget().getSender();
    }

    public User getRecipient() {
        return this.getTarget().getRecipient();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public UserMentionEntity[] getUserMentionEntities() {
        return this.getTarget().getUserMentionEntities();
    }

    public URLEntity[] getURLEntities() {
        return this.getTarget().getURLEntities();
    }

    public HashtagEntity[] getHashtagEntities() {
        return this.getTarget().getHashtagEntities();
    }

    public MediaEntity[] getMediaEntities() {
        return this.getTarget().getMediaEntities();
    }

    public SymbolEntity[] getSymbolEntities() {
        return this.getTarget().getSymbolEntities();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectMessage)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyDirectMessage{target=" + this.getTarget() + "}";
    }
}

