/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.AccountTotals;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyAccountTotals
implements AccountTotals {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private AccountTotals target = null;

    LazyAccountTotals(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private AccountTotals getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createAccountTotals(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public int getUpdates() {
        return this.getTarget().getUpdates();
    }

    public int getFollowers() {
        return this.getTarget().getFollowers();
    }

    public int getFavorites() {
        return this.getTarget().getFavorites();
    }

    public int getFriends() {
        return this.getTarget().getFriends();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountTotals)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyAccountTotals{target=" + this.getTarget() + "}";
    }
}

