/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import twitter4j.AccountSettings;
import twitter4j.Location;
import twitter4j.RateLimitStatus;
import twitter4j.TimeZone;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.z_T4JInternalFactory;

final class LazyAccountSettings
implements AccountSettings {
    private HttpResponse res;
    private z_T4JInternalFactory factory;
    private AccountSettings target = null;

    LazyAccountSettings(HttpResponse res, z_T4JInternalFactory factory) {
        this.res = res;
        this.factory = factory;
    }

    private AccountSettings getTarget() {
        if (this.target == null) {
            try {
                this.target = this.factory.createAccountSettings(this.res);
            }
            catch (TwitterException e) {
                throw new TwitterRuntimeException(e);
            }
        }
        return this.target;
    }

    public boolean isSleepTimeEnabled() {
        return this.getTarget().isSleepTimeEnabled();
    }

    public String getSleepStartTime() {
        return this.getTarget().getSleepStartTime();
    }

    public String getSleepEndTime() {
        return this.getTarget().getSleepEndTime();
    }

    public Location[] getTrendLocations() {
        return this.getTarget().getTrendLocations();
    }

    public boolean isGeoEnabled() {
        return this.getTarget().isGeoEnabled();
    }

    public TimeZone getTimeZone() {
        return this.getTarget().getTimeZone();
    }

    public String getLanguage() {
        return this.getTarget().getLanguage();
    }

    public boolean isDiscoverableByEmail() {
        return this.getTarget().isDiscoverableByEmail();
    }

    public boolean isAlwaysUseHttps() {
        return this.getTarget().isAlwaysUseHttps();
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.getTarget().getRateLimitStatus();
    }

    public int getAccessLevel() {
        return this.getTarget().getAccessLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountSettings)) {
            return false;
        }
        return this.getTarget().equals(o);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return "LazyAccountSettings{target=" + this.getTarget() + "}";
    }
}

