/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http.alternative;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpClientBase;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpRequest;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.RequestMethod;
import twitter4j.internal.http.alternative.AppEngineHttpResponseImpl;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.z_T4JInternalStringUtil;

public class HttpClientImpl
extends HttpClientBase {
    private static Logger logger = Logger.getLogger(HttpClientImpl.class);
    private static final long serialVersionUID = -6969046478967208236L;

    public HttpClientImpl(HttpClientConfiguration conf) {
        super(conf);
    }

    public HttpResponse request(HttpRequest req) throws TwitterException {
        HTTPRequest request;
        try {
            request = new HTTPRequest(new URL(req.getURL()), HTTPMethod.valueOf((String)req.getMethod().name()), FetchOptions.Builder.disallowTruncate().setDeadline(Double.valueOf((double)this.CONF.getHttpReadTimeout() / 1000.0)));
        }
        catch (MalformedURLException e) {
            throw new TwitterException((Exception)e);
        }
        int responseCode = -1;
        try {
            this.setHeaders(req, request);
            if (req.getMethod() == RequestMethod.POST) {
                ByteArrayOutputStream os;
                if (HttpParameter.containsFile((HttpParameter[])req.getParameters())) {
                    String boundary = "----Twitter4J-upload" + System.currentTimeMillis();
                    request.setHeader(new HTTPHeader("Content-Type", "multipart/form-data; boundary=" + boundary));
                    boundary = "--" + boundary;
                    os = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(os);
                    for (HttpParameter param : req.getParameters()) {
                        if (param.isFile()) {
                            this.write(out, boundary + "\r\n");
                            this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"; filename=\"" + param.getFile().getName() + "\"\r\n");
                            this.write(out, "Content-Type: " + param.getContentType() + "\r\n\r\n");
                            BufferedInputStream in = new BufferedInputStream(param.hasFileBody() ? param.getFileBody() : new FileInputStream(param.getFile()));
                            int buff = 0;
                            while ((buff = in.read()) != -1) {
                                out.write(buff);
                            }
                            this.write(out, "\r\n");
                            in.close();
                            continue;
                        }
                        this.write(out, boundary + "\r\n");
                        this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"\r\n");
                        this.write(out, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                        logger.debug(param.getValue());
                        out.write(param.getValue().getBytes("UTF-8"));
                        this.write(out, "\r\n");
                    }
                    this.write(out, boundary + "--\r\n");
                    this.write(out, "\r\n");
                } else {
                    request.setHeader(new HTTPHeader("Content-Type", "application/x-www-form-urlencoded"));
                    String postParam = HttpParameter.encodeParameters((HttpParameter[])req.getParameters());
                    logger.debug("Post Params: ", postParam);
                    byte[] bytes = postParam.getBytes("UTF-8");
                    request.setHeader(new HTTPHeader("Content-Length", Integer.toString(bytes.length)));
                    os = new ByteArrayOutputStream();
                    os.write(bytes);
                }
                request.setPayload(os.toByteArray());
            }
            URLFetchService service = URLFetchServiceFactory.getURLFetchService();
            return new AppEngineHttpResponseImpl(service.fetchAsync(request));
        }
        catch (IOException ioe) {
            throw new TwitterException(ioe.getMessage(), (Exception)ioe, responseCode);
        }
    }

    private void setHeaders(HttpRequest req, HTTPRequest request) {
        String authorizationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(req.getMethod().name() + " ", req.getURL());
        }
        if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authorization: ", z_T4JInternalStringUtil.maskString((String)authorizationHeader));
            }
            request.setHeader(new HTTPHeader("Authorization", authorizationHeader));
        }
        if (null != req.getRequestHeaders()) {
            for (String key : req.getRequestHeaders().keySet()) {
                request.addHeader(new HTTPHeader(key, (String)req.getRequestHeaders().get(key)));
                logger.debug(key + ": " + (String)req.getRequestHeaders().get(key));
            }
        }
    }
}

