/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http.alternative;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import twitter4j.TwitterException;
import twitter4j.TwitterRuntimeException;
import twitter4j.conf.ConfigurationContext;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseCode;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONObject;

final class AppEngineHttpResponseImpl
extends HttpResponse
implements HttpResponseCode {
    private Future<HTTPResponse> future;
    private boolean responseGot;
    private Map<String, String> headers;
    private static Logger logger = Logger.getLogger(AppEngineHttpResponseImpl.class);
    private Throwable th = null;

    AppEngineHttpResponseImpl(Future<HTTPResponse> futureResponse) {
        super((HttpClientConfiguration)ConfigurationContext.getInstance());
        this.future = futureResponse;
    }

    public int getStatusCode() {
        this.ensureResponseEvaluated();
        return this.statusCode;
    }

    public String getResponseHeader(String name) {
        this.ensureResponseEvaluated();
        return this.headers.get(name);
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        this.ensureResponseEvaluated();
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            ret.put(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return ret;
    }

    public InputStream asStream() {
        this.ensureResponseEvaluated();
        return super.asStream();
    }

    public String asString() throws TwitterException {
        this.ensureResponseEvaluated();
        return super.asString();
    }

    public final JSONObject asJSONObject() throws TwitterException {
        this.ensureResponseEvaluated();
        return super.asJSONObject();
    }

    public final JSONArray asJSONArray() throws TwitterException {
        this.ensureResponseEvaluated();
        return super.asJSONArray();
    }

    public final Reader asReader() {
        this.ensureResponseEvaluated();
        return super.asReader();
    }

    public void disconnect() throws IOException {
        if (!this.future.isDone() && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
    }

    private void ensureResponseEvaluated() {
        if (this.th != null) {
            throw new TwitterRuntimeException(this.th);
        }
        if (this.responseGot) {
            return;
        }
        this.responseGot = true;
        if (this.future.isCancelled()) {
            this.th = new TwitterException("HttpResponse already disconnected.");
            throw new TwitterRuntimeException(this.th);
        }
        try {
            HTTPResponse r = this.future.get();
            this.statusCode = r.getResponseCode();
            this.headers = new HashMap<String, String>();
            for (HTTPHeader h : r.getHeaders()) {
                this.headers.put(h.getName().toLowerCase(Locale.ENGLISH), h.getValue());
            }
            byte[] content = r.getContent();
            this.is = new ByteArrayInputStream(content);
            if ("gzip".equals(this.headers.get("content-encoding"))) {
                try {
                    this.is = new GZIPInputStream(this.is);
                }
                catch (IOException e) {
                    this.th = e;
                    throw new TwitterRuntimeException(this.th);
                }
            }
            this.responseAsString = this.inputStreamToString(this.is);
            if ((this.statusCode < 200 || this.statusCode != 302 && 300 <= this.statusCode) && (this.statusCode == 420 || this.statusCode == 400 || this.statusCode < 500)) {
                this.th = new TwitterException(this.responseAsString, null, this.statusCode);
                throw new TwitterRuntimeException(this.th);
            }
        }
        catch (ExecutionException e) {
            this.th = e.getCause();
        }
        catch (InterruptedException e) {
            this.th = e.getCause();
        }
        if (this.th != null) {
            throw new TwitterRuntimeException(this.th);
        }
    }

    private String inputStreamToString(InputStream is) {
        if (this.responseAsString == null) {
            StringBuilder buf = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    buf.append(line);
                }
            }
            catch (IOException e) {
                return null;
            }
            this.responseAsString = buf.toString();
        }
        return this.responseAsString;
    }

    public String toString() {
        return "GAEHttpResponse{future=" + this.future + ", responseGot=" + this.responseGot + ", headers=" + this.headers + '}';
    }
}

