/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.pkgscanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.twdata.pkgscanner.ExportPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPackageListBuilder {
    private static final Log log = LogFactory.getLog(ExportPackageListBuilder.class);
    private Map<String, ExportPackage> packageMap = new HashMap<String, ExportPackage>();

    public void add(ExportPackage exportPackage) {
        String packageName = exportPackage.getPackageName();
        ExportPackage currentExportPackage = this.packageMap.get(packageName);
        if (currentExportPackage == null) {
            this.packageMap.put(packageName, exportPackage);
        } else if (exportPackage.getVersion() == null) {
            if (currentExportPackage.getVersion() != null) {
                this.logDuplicateWarning(exportPackage, currentExportPackage);
            }
        } else if (currentExportPackage.getVersion() == null) {
            this.packageMap.put(packageName, exportPackage);
            this.logDuplicateWarning(exportPackage, currentExportPackage);
        } else {
            if (!currentExportPackage.getVersion().equals(exportPackage.getVersion())) {
                this.logDuplicateWarning(exportPackage, currentExportPackage);
            }
            this.packageMap.put(packageName, exportPackage);
        }
    }

    private void logDuplicateWarning(ExportPackage exportPackage1, ExportPackage exportPackage2) {
        log.warn((Object)("Package Scanner found duplicates for package '" + exportPackage1.getPackageName() + "' with different versions. Files: " + exportPackage1.getLocation().getName() + " and " + exportPackage2.getLocation().getName()));
    }

    public List<ExportPackage> getPackageList() {
        ArrayList<ExportPackage> packageList = new ArrayList<ExportPackage>(this.packageMap.values());
        Collections.sort(packageList);
        return packageList;
    }
}

