/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.runnable;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.tuzhao.netty.channel.ChannelClient;
import org.tuzhao.netty.channel.ChannelInit;
import org.tuzhao.netty.listener.ChannelCallback;
import org.tuzhao.netty.listener.ConnectListener;
import org.tuzhao.netty.main.Component;
import org.tuzhao.netty.main.NettyState;
import org.tuzhao.netty.main.SlimInter;

public final class ReconnectRunnable
implements Runnable {
    private final SlimInter netty;
    private final String json;
    private final Component component;
    private final ChannelClient client;
    private final long all;
    private final long read;
    private final long write;

    public ReconnectRunnable(ChannelClient client, String json) {
        this.netty = client.getNetty();
        this.json = json;
        this.client = client;
        this.component = this.netty.getComponent();
        this.all = this.netty.getFreeTimeAll();
        this.read = this.netty.getFreeTimeRead();
        this.write = this.netty.getFreeTimeWrite();
    }

    @Override
    public void run() {
        if (this.netty.isHaveNet()) {
            if (!NettyState.getNetState()) {
                this.netty.shutDownSocketFromUser();
                try {
                    if (this.component.getGroup() == null) {
                        this.component.setGroup(new NioEventLoopGroup());
                    }
                    Bootstrap bootstrap = new Bootstrap();
                    bootstrap.group((EventLoopGroup)this.component.getGroup());
                    bootstrap.channel(NioSocketChannel.class);
                    bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                    bootstrap.handler((ChannelHandler)new ChannelInit(this.all, this.read, this.write, this.netty.getDecoder(), this.netty.getEncoder(), this.client));
                    int port = this.netty.getPort();
                    String host = this.netty.getRealHost();
                    ConnectListener listener = new ConnectListener(new ChannelCallback(){

                        @Override
                        public void complete(ChannelFuture future) {
                            future.channel().writeAndFlush((Object)ReconnectRunnable.this.json);
                        }
                    });
                    this.component.setChannel(bootstrap.connect(host, port).addListener((GenericFutureListener)listener));
                }
                catch (Exception e) {
                    this.netty.getLogManager().ie(e);
                }
            }
        } else {
            this.it("reconnect don't have network");
        }
        if (!NettyState.getNetState()) {
            this.it("reconnect will try reconnect next time");
            this.netty.getHandler().postDelayed((Runnable)this, 3000L);
        }
    }

    private void it(Object msg) {
        this.netty.getLogManager().it(msg);
    }
}

