/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.queue;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tuzhao.netty.request.BaseRequest;
import org.tuzhao.netty.request.HeartbeatInter;
import org.tuzhao.netty.request.RequestInter;

public final class NettyRequestQueue {
    private static final NettyRequestQueue instance = new NettyRequestQueue();
    private final ConcurrentHashMap<Object, BaseRequest> queue = new ConcurrentHashMap();

    public static NettyRequestQueue getInstance() {
        return instance;
    }

    private NettyRequestQueue() {
    }

    public void add(RequestInter data) {
        BaseRequest request = new BaseRequest();
        request.setRequestKey(data.getRequestQueueKey());
        request.setRequestJson(data.getRequestJson());
        request.setRequestTime(System.currentTimeMillis());
        request.setCallback(data.getRequestCallback());
        this.queue.put(data.getRequestQueueKey(), request);
    }

    public void heartbeat(HeartbeatInter data) {
        BaseRequest request = new BaseRequest();
        request.setRequestKey(data.getRequestQueueKey());
        request.setRequestJson(data.getRequestJson());
        request.setRequestTime(System.currentTimeMillis());
        request.setCallback(null);
        this.queue.put(data.getRequestQueueKey(), request);
    }

    public boolean containsKey(Object key) {
        return key != null && this.queue.containsKey(key);
    }

    public BaseRequest remove(Object key) {
        return this.queue.remove(key);
    }

    public int size() {
        return this.queue.size();
    }

    public Set<Map.Entry<Object, BaseRequest>> entrySet() {
        return this.queue.entrySet();
    }
}

