/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.main;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import org.tuzhao.netty.channel.ChannelClient;
import org.tuzhao.netty.channel.ChannelInit;
import org.tuzhao.netty.coding.NettyDecoder;
import org.tuzhao.netty.coding.NettyEncoder;
import org.tuzhao.netty.listener.ChannelCallback;
import org.tuzhao.netty.listener.ConnectListener;
import org.tuzhao.netty.log.LogManager;
import org.tuzhao.netty.main.Component;
import org.tuzhao.netty.main.NettyState;
import org.tuzhao.netty.main.SlimInter;
import org.tuzhao.netty.queue.NettyRequestQueue;
import org.tuzhao.netty.request.HeartbeatInter;
import org.tuzhao.netty.request.RequestInter;
import org.tuzhao.netty.runnable.FirstRunnable;
import org.tuzhao.netty.runnable.ReconnectRunnable;

public final class SlimNetty
implements SlimInter {
    private final int port;
    private final String host;
    private final Context context;
    private final long timeoutFirst;
    private final long timeoutNormal;
    private final long timeReconnect;
    private final long freeTimeAll;
    private final long freeTimeRead;
    private final long freeTimeWrite;
    private volatile String realHost;
    private final Handler handler;
    private final Component component;
    private ConnectivityManager manager;
    private final LogManager logManager;
    private Class<? extends ByteToMessageDecoder> decoder;
    private Class<? extends MessageToByteEncoder> encoder;
    private FirstRunnable fRunnable;
    private ReconnectRunnable rRunnable;

    public SlimNetty(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.context = builder.context;
        this.timeoutFirst = builder.timeoutFirst;
        this.timeoutNormal = builder.timeoutNormal;
        this.timeReconnect = builder.timeReconnect;
        this.handler = new Handler(this.context.getMainLooper());
        this.component = new Component();
        this.logManager = new LogManager(builder.debug);
        this.decoder = builder.decoder;
        this.encoder = builder.encoder;
        this.freeTimeAll = builder.freeTimeAll;
        this.freeTimeRead = builder.freeTimeRead;
        this.freeTimeWrite = builder.freeTimeWrite;
    }

    @Override
    public void sendRequest(RequestInter request, ChannelClient client) {
        if (this.isHaveNet()) {
            this.initChannel(request, client);
            this.firstRunnableStart();
        } else {
            request.getRequestCallback().onNoNetwork();
        }
    }

    @Override
    public void sendRequest(RequestInter request) {
        if (this.isHaveNet() && NettyState.getNetState()) {
            this.flushRequest(request);
        } else {
            request.getRequestCallback().onNoNetwork();
            this.shutDownSocketFromSystem();
        }
    }

    @Override
    public void cancelRequest(Object requestKey) {
        NettyRequestQueue.getInstance().remove(requestKey);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealHost() {
        return this.realHost == null ? "" : this.realHost;
    }

    @Override
    public long getTimeout() {
        return this.timeoutNormal;
    }

    @Override
    public void flushRequest(RequestInter request) {
        ChannelFuture channel = this.component.getChannel();
        if (request != null && channel != null) {
            NettyRequestQueue.getInstance().add(request);
            this.it("params", request.getRequestJson());
            channel.channel().writeAndFlush((Object)request.getRequestJson());
        }
    }

    @Override
    public void flushHeartbeat(HeartbeatInter heartbeat) {
        ChannelFuture channel = this.component.getChannel();
        if (heartbeat != null && channel != null) {
            NettyRequestQueue.getInstance().heartbeat(heartbeat);
            this.it("heart beat", heartbeat.getRequestJson());
            channel.channel().writeAndFlush((Object)heartbeat.getRequestJson());
        }
    }

    @Override
    public void shutDownSocketFromUser() {
        NettyState.setExitState(true);
        NettyState.setNetState(false);
        NettyState.setLinkState(false);
        this.shutDownSocket();
        this.it("shutDownSocketFromUser");
    }

    @Override
    public void shutDownSocketFromSystem() {
        NettyState.setExitState(false);
        NettyState.setNetState(false);
        this.shutDownSocket();
        this.it("shutDownSocketFromSystem");
    }

    private void shutDownSocket() {
        try {
            if (this.component.getGroup() != null) {
                this.component.getGroup().shutdownGracefully();
            }
            this.component.cleanAll();
        }
        catch (Exception e) {
            this.getLogManager().ie(e);
        }
    }

    @Override
    public void firstRunnableStart() {
        if (this.fRunnable == null) {
            this.fRunnable = new FirstRunnable(this);
        }
        this.getHandler().postDelayed((Runnable)this.fRunnable, this.timeoutFirst);
    }

    @Override
    public void firstRunnableEnd() {
        if (this.fRunnable != null) {
            this.getHandler().removeCallbacks((Runnable)this.fRunnable);
        }
        this.fRunnable = null;
    }

    @Override
    public void reconnectRunnableStart(ChannelClient client, String json) {
        if (!NettyState.getLinkState()) {
            NettyState.setLinkState(true);
            if (this.rRunnable == null) {
                this.rRunnable = new ReconnectRunnable(client, json);
            }
            this.getHandler().postDelayed((Runnable)this.rRunnable, this.timeReconnect);
        }
    }

    @Override
    public void reconnectRunnableEnd() {
        if (this.rRunnable != null) {
            this.getHandler().removeCallbacks((Runnable)this.rRunnable);
        }
        this.rRunnable = null;
        NettyState.setLinkState(false);
    }

    @Override
    public LogManager getLogManager() {
        return this.logManager;
    }

    @Override
    public Class<? extends ByteToMessageDecoder> getDecoder() {
        return this.decoder;
    }

    @Override
    public Class<? extends MessageToByteEncoder> getEncoder() {
        return this.encoder;
    }

    @Override
    public long getFreeTimeAll() {
        return this.freeTimeAll;
    }

    @Override
    public long getFreeTimeRead() {
        return this.freeTimeRead;
    }

    @Override
    public long getFreeTimeWrite() {
        return this.freeTimeWrite;
    }

    private void initChannel(final RequestInter request, final ChannelClient client) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress byName = InetAddress.getByName(SlimNetty.this.host);
                    String ip = byName.getHostAddress();
                    SlimNetty.this.realHost = ip;
                    if (SlimNetty.this.component.getGroup() == null) {
                        SlimNetty.this.component.setGroup(new NioEventLoopGroup());
                    }
                    Bootstrap bootstrap = new Bootstrap();
                    bootstrap.group((EventLoopGroup)SlimNetty.this.component.getGroup());
                    bootstrap.channel(NioSocketChannel.class);
                    bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                    bootstrap.handler((ChannelHandler)new ChannelInit(SlimNetty.this.freeTimeAll, SlimNetty.this.freeTimeRead, SlimNetty.this.freeTimeWrite, SlimNetty.this.decoder, SlimNetty.this.encoder, client));
                    ConnectListener listener = new ConnectListener(new ChannelCallback(){

                        @Override
                        public void complete(ChannelFuture future) {
                            SlimNetty.this.flushRequest(request);
                        }
                    });
                    SlimNetty.this.component.setChannel(bootstrap.connect(ip, SlimNetty.this.port).addListener((GenericFutureListener)listener));
                }
                catch (Exception e) {
                    SlimNetty.this.getLogManager().ie(e);
                }
            }
        }).start();
    }

    @Override
    public boolean isHaveNet() {
        try {
            if (this.context != null) {
                NetworkInfo info;
                if (this.manager == null) {
                    this.manager = (ConnectivityManager)this.context.getSystemService("connectivity");
                }
                if ((info = this.manager.getActiveNetworkInfo()) != null) {
                    return info.isAvailable();
                }
            }
        }
        catch (Exception e) {
            this.getLogManager().ie(e);
        }
        return false;
    }

    @Override
    public void notifyNetworkNormal() {
        this.firstRunnableEnd();
        this.reconnectRunnableEnd();
        NettyState.setNetState(true);
        NettyState.setLinkState(false);
        NettyState.setExitState(false);
    }

    private void it(Object tag, Object des) {
        this.getLogManager().it(tag, des);
    }

    private void it(Object des) {
        this.getLogManager().it(des);
    }

    public static class Builder {
        private int port;
        private String host;
        private boolean debug;
        private Context context;
        private long timeoutFirst;
        private long timeoutNormal;
        private long timeReconnect;
        private long freeTimeAll;
        private long freeTimeRead;
        private long freeTimeWrite;
        private Class<? extends ByteToMessageDecoder> decoder;
        private Class<? extends MessageToByteEncoder> encoder;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
            this.timeoutFirst = 20000L;
            this.timeoutNormal = 30000L;
            this.timeReconnect = 3000L;
            this.freeTimeAll = 28000L;
            this.freeTimeRead = 10000L;
            this.freeTimeWrite = 20000L;
            this.decoder = NettyDecoder.class;
            this.encoder = NettyEncoder.class;
        }

        public Builder host(String host) {
            if (host == null) {
                throw new IllegalArgumentException("host can't be null");
            }
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder timeoutFirst(long time) {
            this.timeoutFirst = time;
            return this;
        }

        public Builder timeoutNormal(long time) {
            this.timeoutNormal = time;
            return this;
        }

        public Builder timeReconnect(long time) {
            this.timeReconnect = time;
            return this;
        }

        public Builder freeTimeAll(long time) {
            this.freeTimeAll = time;
            return this;
        }

        public Builder freeTimeRead(long time) {
            this.freeTimeRead = time;
            return this;
        }

        public Builder freeTimeWrite(long time) {
            this.freeTimeWrite = time;
            return this;
        }

        public Builder decoder(Class<? extends ByteToMessageDecoder> decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder encoder(Class<? extends MessageToByteEncoder> encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder debug(boolean flag) {
            this.debug = flag;
            return this;
        }

        public SlimNetty build() {
            return new SlimNetty(this);
        }
    }
}

