/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.coding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public final class NettyDecoder
extends ByteToMessageDecoder {
    private static final int HEAD_LENGTH = 4;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int dataLength = in.readInt();
        if (dataLength < 0) {
            ctx.close();
        }
        if (in.readableBytes() < dataLength - 4) {
            in.resetReaderIndex();
            return;
        }
        byte[] body = new byte[dataLength - 4];
        in.readBytes(body);
        out.add(new String(body));
    }
}

