/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.tuzhao.netty.channel.ChannelClient;

public final class ChannelInit
extends ChannelInitializer<SocketChannel> {
    private final Class<? extends ByteToMessageDecoder> decoder;
    private final Class<? extends MessageToByteEncoder> encoder;
    private final ChannelInboundHandlerAdapter channelClient;
    private final long freeTimeAll;
    private final long freeTimeRead;
    private final long freeTimeWrite;

    public ChannelInit(long all, long read, long write, Class<? extends ByteToMessageDecoder> decoder, Class<? extends MessageToByteEncoder> encoder, ChannelClient channelClient) {
        this.freeTimeAll = all;
        this.freeTimeRead = read;
        this.freeTimeWrite = write;
        this.decoder = decoder;
        this.encoder = encoder;
        this.channelClient = channelClient;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)this.decoder.newInstance()});
        ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)this.encoder.newInstance()});
        ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(this.freeTimeRead, this.freeTimeWrite, this.freeTimeAll, TimeUnit.MILLISECONDS)});
        ch.pipeline().addLast(new ChannelHandler[]{this.channelClient});
    }
}

