/*
 * Decompiled with CFR 0.152.
 */
package org.tuzhao.netty.channel;

import android.os.Handler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Map;
import org.tuzhao.netty.main.NettyState;
import org.tuzhao.netty.main.SlimInter;
import org.tuzhao.netty.queue.NettyRequestQueue;
import org.tuzhao.netty.request.BaseRequest;
import org.tuzhao.netty.request.RequestCallback;

@ChannelHandler.Sharable
public abstract class ChannelClient
extends ChannelInboundHandlerAdapter {
    private volatile int requestCount = 0;
    private final SlimInter netty;
    private final Handler handler;
    private final NettyRequestQueue queue;

    public ChannelClient(SlimInter netty) {
        this.netty = netty;
        this.handler = netty.getHandler();
        this.queue = NettyRequestQueue.getInstance();
    }

    public void channelRead(ChannelHandlerContext ctx, final Object msg) throws Exception {
        BaseRequest request;
        RequestCallback callback;
        if (this.requestCount % 10 == 0) {
            this.requestCount = 0;
            this.netty.notifyNetworkNormal();
        }
        ++this.requestCount;
        this.it("original json", msg.toString());
        if (this.dealHeartbeat(msg)) {
            return;
        }
        if (this.dealPushFromServer(msg)) {
            return;
        }
        Object key = this.getRequestKey(msg);
        boolean b = this.queue.containsKey(key);
        if (b && (callback = (request = this.queue.remove(key)).getCallback()) != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ChannelClient.this.it("handler thread", Thread.currentThread().getName());
                    callback.onResponse(msg);
                }
            });
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.it("channelInactive");
        super.channelInactive(ctx);
        this.requestCount = 0;
        boolean exitState = NettyState.getExitState();
        if (!exitState) {
            this.getNetty().shutDownSocketFromSystem();
            this.getNetty().reconnectRunnableStart(this.getChannelClient(), this.sendHeartbeat());
            this.channelInactive();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.it("exceptionCaught");
        this.requestCount = 0;
        this.getNetty().shutDownSocketFromSystem();
        this.getNetty().reconnectRunnableStart(this.getChannelClient(), this.sendHeartbeat());
        this.channelException();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                this.dealTimeOutRequest();
                this.freeRead();
            } else if (event.state() == IdleState.WRITER_IDLE) {
                this.freeWrite();
            } else if (event.state() == IdleState.ALL_IDLE) {
                this.sendHeartbeat();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    public void dealTimeOutRequest() {
        if (this.queue.size() > 0) {
            for (Map.Entry<Object, BaseRequest> entry : this.queue.entrySet()) {
                long nowTime;
                final BaseRequest request = entry.getValue();
                Object requestKey = request.getRequestKey();
                long requestTime = request.getRequestTime();
                long maxTime = requestTime + this.getNetty().getTimeout();
                if (maxTime < (nowTime = System.currentTimeMillis())) {
                    this.it("time out", "request : " + requestKey + " has been timeout!");
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.getCallback().onTimeout();
                        }
                    });
                    continue;
                }
                this.it("Request", "send time:" + requestTime);
                this.it("Request", "max time:" + maxTime);
                this.it("Request", "now time:" + nowTime);
                this.it("Request", requestKey + " maybe time out later!");
            }
        } else {
            this.it("check request queue", "size = 0");
        }
    }

    private void it(String tag, Object des) {
        this.netty.getLogManager().it(tag, des);
    }

    private void it(Object des) {
        this.netty.getLogManager().it(des);
    }

    public SlimInter getNetty() {
        return this.netty;
    }

    public abstract boolean dealPushFromServer(Object var1);

    public abstract boolean dealHeartbeat(Object var1);

    public abstract Object getRequestKey(Object var1);

    public abstract void channelException();

    public abstract void channelInactive();

    public abstract ChannelClient getChannelClient();

    public abstract void freeRead();

    public abstract void freeWrite();

    public abstract String sendHeartbeat();
}

