/*
 * Decompiled with CFR 0.152.
 */
package org.tuxdevelop.spring.batch.lightmin.client.classic.service;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.tuxdevelop.spring.batch.lightmin.client.classic.service.LightminClientRegistratorService;

public class LightminClientApplicationRegistrationService {
    private static final Logger log = LoggerFactory.getLogger(LightminClientApplicationRegistrationService.class);
    private boolean autoDeregister = false;
    private boolean autoRegister = true;
    private long registerPeriod = 10000L;
    private volatile ScheduledFuture<?> scheduledTask;
    private final LightminClientRegistratorService lightminClientRegistrator;
    private final TaskScheduler taskScheduler;

    public LightminClientApplicationRegistrationService(LightminClientRegistratorService lightminClientRegistrator, TaskScheduler taskScheduler) {
        this.lightminClientRegistrator = lightminClientRegistrator;
        this.taskScheduler = taskScheduler;
    }

    public LightminClientApplicationRegistrationService(LightminClientRegistratorService lightminClientRegistrator, ScheduledExecutorService scheduler) {
        this(lightminClientRegistrator, (TaskScheduler)new ConcurrentTaskScheduler(scheduler));
    }

    public LightminClientApplicationRegistrationService(LightminClientRegistratorService lightminClientRegistrator) {
        this(lightminClientRegistrator, Executors.newSingleThreadScheduledExecutor());
    }

    public void startRegisterTask() {
        if (this.autoRegister) {
            if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
                return;
            }
            this.scheduledTask = this.taskScheduler.scheduleAtFixedRate(this.lightminClientRegistrator::register, this.registerPeriod);
            log.debug("Scheduled registration task for every {}ms", (Object)this.registerPeriod);
        }
    }

    public void stopRegisterTask() {
        if (this.autoDeregister && this.scheduledTask != null && !this.scheduledTask.isDone()) {
            this.scheduledTask.cancel(Boolean.TRUE);
            log.debug("Canceled registration task");
        }
    }

    public void setAutoDeregister(boolean autoDeregister) {
        this.autoDeregister = autoDeregister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setRegisterPeriod(long registerPeriod) {
        this.registerPeriod = registerPeriod;
    }
}

