/*
 * Decompiled with CFR 0.152.
 */
package org.tuxdevelop.spring.batch.lightmin.client.classic.configuration;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="spring.batch.lightmin.client.classic")
public class LightminClientClassicConfigurationProperties {
    private boolean autoDeregistration = Boolean.TRUE;
    private boolean autoRegistration = Boolean.TRUE;
    private boolean registerOnce = Boolean.FALSE;
    private Long period = 10000L;
    @NestedConfigurationProperty
    private LightminClientServerProperties server = new LightminClientServerProperties();

    public boolean isAutoDeregistration() {
        return this.autoDeregistration;
    }

    public boolean isAutoRegistration() {
        return this.autoRegistration;
    }

    public boolean isRegisterOnce() {
        return this.registerOnce;
    }

    public Long getPeriod() {
        return this.period;
    }

    public LightminClientServerProperties getServer() {
        return this.server;
    }

    public void setAutoDeregistration(boolean autoDeregistration) {
        this.autoDeregistration = autoDeregistration;
    }

    public void setAutoRegistration(boolean autoRegistration) {
        this.autoRegistration = autoRegistration;
    }

    public void setRegisterOnce(boolean registerOnce) {
        this.registerOnce = registerOnce;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public void setServer(LightminClientServerProperties server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightminClientClassicConfigurationProperties)) {
            return false;
        }
        LightminClientClassicConfigurationProperties other = (LightminClientClassicConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoDeregistration() != other.isAutoDeregistration()) {
            return false;
        }
        if (this.isAutoRegistration() != other.isAutoRegistration()) {
            return false;
        }
        if (this.isRegisterOnce() != other.isRegisterOnce()) {
            return false;
        }
        Long this$period = this.getPeriod();
        Long other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        LightminClientServerProperties this$server = this.getServer();
        LightminClientServerProperties other$server = other.getServer();
        return !(this$server == null ? other$server != null : !((Object)this$server).equals(other$server));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LightminClientClassicConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoDeregistration() ? 79 : 97);
        result = result * 59 + (this.isAutoRegistration() ? 79 : 97);
        result = result * 59 + (this.isRegisterOnce() ? 79 : 97);
        Long $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        LightminClientServerProperties $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        return result;
    }

    public String toString() {
        return "LightminClientClassicConfigurationProperties(autoDeregistration=" + this.isAutoDeregistration() + ", autoRegistration=" + this.isAutoRegistration() + ", registerOnce=" + this.isRegisterOnce() + ", period=" + this.getPeriod() + ", server=" + this.getServer() + ")";
    }

    public static class LightminClientServerProperties {
        private String[] url;
        private String apiApplicationsPath = "api/applications";

        public String[] getLightminUrl() {
            String[] adminUrls = this.url != null ? (String[])this.url.clone() : new String[]{};
            return adminUrls;
        }

        public String[] getUrl() {
            return this.url;
        }

        public String getApiApplicationsPath() {
            return this.apiApplicationsPath;
        }

        public void setUrl(String[] url) {
            this.url = url;
        }

        public void setApiApplicationsPath(String apiApplicationsPath) {
            this.apiApplicationsPath = apiApplicationsPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LightminClientServerProperties)) {
                return false;
            }
            LightminClientServerProperties other = (LightminClientServerProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getUrl(), other.getUrl())) {
                return false;
            }
            String this$apiApplicationsPath = this.getApiApplicationsPath();
            String other$apiApplicationsPath = other.getApiApplicationsPath();
            return !(this$apiApplicationsPath == null ? other$apiApplicationsPath != null : !this$apiApplicationsPath.equals(other$apiApplicationsPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LightminClientServerProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getUrl());
            String $apiApplicationsPath = this.getApiApplicationsPath();
            result = result * 59 + ($apiApplicationsPath == null ? 43 : $apiApplicationsPath.hashCode());
            return result;
        }

        public String toString() {
            return "LightminClientClassicConfigurationProperties.LightminClientServerProperties(url=" + Arrays.deepToString(this.getUrl()) + ", apiApplicationsPath=" + this.getApiApplicationsPath() + ")";
        }
    }
}

