/*
 * Decompiled with CFR 0.152.
 */
package org.tuxdevelop.spring.batch.lightmin.client.classic.service;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuxdevelop.spring.batch.lightmin.client.classic.configuration.LightminClientClassicConfigurationProperties;
import org.tuxdevelop.spring.batch.lightmin.client.service.LightminServerLocatorService;
import org.tuxdevelop.spring.batch.lightmin.exception.SpringBatchLightminConfigurationException;

public class UrlLightminServerLocatorService
implements LightminServerLocatorService {
    private static final Logger log = LoggerFactory.getLogger(UrlLightminServerLocatorService.class);
    private final LightminClientClassicConfigurationProperties lightminClientClassicConfigurationProperties;

    public UrlLightminServerLocatorService(LightminClientClassicConfigurationProperties lightminClientClassicConfigurationProperties) {
        this.lightminClientClassicConfigurationProperties = lightminClientClassicConfigurationProperties;
    }

    public List<String> getRemoteUrls() {
        if (this.lightminClientClassicConfigurationProperties.getServer().getLightminUrl() == null || this.lightminClientClassicConfigurationProperties.getServer().getLightminUrl().length == 0) {
            throw new SpringBatchLightminConfigurationException("The lightmin server urls must not be null or empty");
        }
        List<String> urls = Arrays.asList(this.lightminClientClassicConfigurationProperties.getServer().getLightminUrl());
        log.debug("Configured lightmin server urls {}", urls);
        return urls;
    }
}

