/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.event;

import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.trpr.platform.core.impl.event.PlatformApplicationEvent;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.event.PlatformEventConsumer;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.event.PlatformEvent;

public class BootstrapProgressMonitor
implements PlatformEventConsumer {
    private static final Logger LOGGER = LogFactory.getLogger(BootstrapProgressMonitor.class);
    private static final int BOOTSTRAP_IN_PROGRESS = 0;
    private static final int BOOTSTRAP_COMPLETE = 1;
    private static volatile int bootstrapState = 0;
    private List<PlatformEventConsumer> bootstrapEventListeners = new LinkedList<PlatformEventConsumer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void waitForBootstrapComplete() {
        while (bootstrapState == 0) {
            Class<BootstrapProgressMonitor> clazz = BootstrapProgressMonitor.class;
            // MONITORENTER : org.trpr.platform.runtime.impl.event.BootstrapProgressMonitor.class
            try {
                LOGGER.info("Bootstrap in progress. BootstrapProgressMonitor waiting to be notified on completion for thread : " + Thread.currentThread());
                BootstrapProgressMonitor.class.wait();
                LOGGER.info("Bootstrap completed. BootstrapProgressMonitor allowing thread to continue : " + Thread.currentThread());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onApplicationEvent(PlatformApplicationEvent event) {
        PlatformEvent platformEvent;
        if (!(event.getSource() instanceof PlatformEvent) || (platformEvent = (PlatformEvent)event.getSource()).getEventType() == null || !platformEvent.getEventType().equalsIgnoreCase("BootstrapMonitoredEvent")) return;
        Class<BootstrapProgressMonitor> clazz = BootstrapProgressMonitor.class;
        synchronized (BootstrapProgressMonitor.class) {
            if (platformEvent.getEventStatus() != null && platformEvent.getEventStatus().equalsIgnoreCase("started")) {
                bootstrapState = 1;
                BootstrapProgressMonitor.class.notifyAll();
            } else if (platformEvent.getEventStatus() != null && platformEvent.getEventStatus().equalsIgnoreCase("stopped")) {
                bootstrapState = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (PlatformEventConsumer bootstrapEventListener : this.bootstrapEventListeners) {
                bootstrapEventListener.onApplicationEvent((ApplicationEvent)event);
            }
            return;
        }
    }

    public void addBootstrapEventListener(PlatformEventConsumer bootstrapEventListener) {
        this.bootstrapEventListeners.add(bootstrapEventListener);
    }

    public boolean removeBootstrapEventListener(PlatformEventConsumer bootstrapEventListener) {
        return this.bootstrapEventListeners.remove(bootstrapEventListener);
    }
}

