/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;

@Internal
public final class Iterables {
    private Iterables() {
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static <T> Iterator<T> singletonIterator(final T element) {
        Checker.checkArgumentNotNull(element);
        return new Iterator<T>(){
            private AtomicBoolean hasNext = new AtomicBoolean(true);

            @Override
            public boolean hasNext() {
                return this.hasNext.get();
            }

            @Override
            public T next() {
                if (this.hasNext.get()) {
                    this.hasNext.set(false);
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

