/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.trimou.annotations.Internal;

@Internal
public final class ImmutableSet {
    private ImmutableSet() {
    }

    public static <T> Set<T> copyOf(Set<T> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(new HashSet<T>(set));
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... elements) {
        if (elements.length == 0) {
            return Collections.emptySet();
        }
        if (elements.length == 1) {
            return Collections.singleton(elements[0]);
        }
        HashSet set = new HashSet();
        Collections.addAll(set, elements);
        return Collections.unmodifiableSet(set);
    }

    public static <T> ImmutableSetBuilder<T> builder() {
        return new ImmutableSetBuilder();
    }

    public static final class ImmutableSetBuilder<T> {
        private Set<T> elements = new HashSet<T>();

        private ImmutableSetBuilder() {
        }

        public ImmutableSetBuilder<T> add(T element) {
            this.elements.add(element);
            return this;
        }

        public Set<T> build() {
            return ImmutableSet.copyOf(this.elements);
        }
    }
}

