/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.trimou.annotations.Internal;

@Internal
public final class ImmutableMap {
    private ImmutableMap() {
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <K, V> Map<K, V> of(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2) {
        return ImmutableMap.builder().put(key1, value1).put(key2, value2).build();
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return ImmutableMap.builder().put(key1, value1).put(key2, value2).put(key3, value3).build();
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return ImmutableMap.builder().put(key1, value1).put(key2, value2).put(key3, value3).put(key4, value4).build();
    }

    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        return ImmutableMap.builder().put(key1, value1).put(key2, value2).put(key3, value3).put(key4, value4).put(key5, value5).build();
    }

    public static <K, V> ImmutableMapBuilder<K, V> builder() {
        return new ImmutableMapBuilder();
    }

    public static final class ImmutableMapBuilder<K, V> {
        private Map<K, V> entries = new HashMap();

        private ImmutableMapBuilder() {
        }

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.entries.put(key, value);
            return this;
        }

        public Map<K, V> build() {
            return ImmutableMap.copyOf(this.entries);
        }
    }
}

