/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.util.ImmutableArrayList;

@Internal
public final class ImmutableList {
    private ImmutableList() {
    }

    public static <T> List<T> copyOf(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ImmutableArrayList(list.toArray());
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements) {
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        if (elements.length == 1) {
            return Collections.singletonList(elements[0]);
        }
        return new ImmutableArrayList(elements);
    }

    public static <T> ImmutableListBuilder<T> builder() {
        return new ImmutableListBuilder();
    }

    public static final class ImmutableListBuilder<T> {
        private List<T> elements = new ArrayList<T>();

        private ImmutableListBuilder() {
        }

        public ImmutableListBuilder<T> add(T element) {
            this.elements.add(element);
            return this;
        }

        public List<T> build() {
            return ImmutableList.copyOf(this.elements);
        }
    }
}

