/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    static Method[] getMethods(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getMethods();
            }
        });
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            accessibleObject.setAccessible(true);
        }
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }
}

