/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Options;
import org.trimou.util.ImmutableSet;

abstract class MatchingSectionHelper
extends BasicSectionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchingSectionHelper.class);
    private final String elseStartDelimiter;
    private final Pattern elsePattern;

    MatchingSectionHelper() {
        this(EngineConfigurationKey.START_DELIMITER.getDefaultValue().toString().substring(0, 1), EngineConfigurationKey.END_DELIMITER.getDefaultValue().toString().substring(0, 1));
    }

    MatchingSectionHelper(String elseStartDelimiter, String elseEndDelimiter) {
        this.elseStartDelimiter = elseStartDelimiter;
        this.elsePattern = MatchingSectionHelper.initElsePattern(elseStartDelimiter, elseEndDelimiter);
    }

    @Override
    public void execute(Options options) {
        if (options.getParameters().isEmpty() && this.isMatching(options.peek(), options) || this.matches(options)) {
            options.fn();
        } else {
            Object elseBlock = options.getHash().get("else");
            if (elseBlock != null) {
                String elseString = elseBlock.toString();
                if (elseString.contains(this.elseStartDelimiter)) {
                    this.append(options, this.interpolate(elseString, options));
                } else {
                    this.append(options, elseString);
                }
            }
        }
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("logic", "else");
    }

    protected EvaluationLogic getDefaultLogic() {
        return EvaluationLogic.AND;
    }

    protected abstract boolean isMatching(Object var1);

    protected boolean isMatching(Object value, Options options) {
        return this.isMatching(value);
    }

    protected boolean hasEmptyParamsSupport() {
        return false;
    }

    @Override
    protected int numberOfRequiredParameters() {
        return this.hasEmptyParamsSupport() ? 0 : super.numberOfRequiredParameters();
    }

    private boolean matches(Options options) {
        List<Object> params = options.getParameters();
        if (params.size() == 1) {
            return this.isMatching(params.get(0), options);
        }
        EvaluationLogic logic = this.getLogic(options.getHash());
        for (Object param : params) {
            Boolean value = logic.test(this.isMatching(param, options));
            if (value == null) continue;
            return value;
        }
        return logic.defaultResult();
    }

    private EvaluationLogic getLogic(Map<String, Object> hash) {
        if (hash.isEmpty() || !hash.containsKey("logic")) {
            return this.getDefaultLogic();
        }
        String customLogic = hash.get("logic").toString();
        EvaluationLogic logic = EvaluationLogic.parse(customLogic);
        if (logic == null) {
            LOGGER.warn("Unsupported evaluation logic specified: {}, using the default one: {}", (Object)customLogic, (Object)this.getDefaultLogic());
            logic = this.getDefaultLogic();
        }
        return logic;
    }

    private String interpolate(String elseString, Options options) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = this.elsePattern.matcher(elseString);
        while (matcher.find()) {
            Object value = options.getValue(matcher.group(2).trim());
            String replacement = value != null ? value.toString() : "";
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    static Pattern initElsePattern(String elseStartDelimiter, String elseEndDelimiter) {
        return Pattern.compile("(" + Pattern.quote(elseStartDelimiter) + ")(.*?)(" + Pattern.quote(elseEndDelimiter) + ")");
    }

    protected static enum EvaluationLogic {
        OR{

            @Override
            Boolean test(boolean isMatching) {
                return isMatching ? Boolean.valueOf(true) : null;
            }

            @Override
            boolean defaultResult() {
                return false;
            }
        }
        ,
        AND{

            @Override
            Boolean test(boolean isMatching) {
                return !isMatching ? Boolean.valueOf(false) : null;
            }

            @Override
            boolean defaultResult() {
                return true;
            }
        };


        abstract Boolean test(boolean var1);

        abstract boolean defaultResult();

        public static EvaluationLogic parse(String value) {
            for (EvaluationLogic logic : EvaluationLogic.values()) {
                if (!value.equalsIgnoreCase(logic.toString())) continue;
                return logic;
            }
            return null;
        }
    }
}

