/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.HelperValidator;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.SecurityActions;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Primitives;

public class InvokeHelper
extends BasicHelper {
    public static final ConfigurationKey METHOD_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(InvokeHelper.class.getName() + ".methodCacheMaxSize", 500L);
    private volatile ComputingCache<MethodKey, Optional<Method>> methodCache;
    private final ClassLoader classLoader;
    private final String defaultMethodName;

    public static InvokeHelper of(String defaultMethodName) {
        return new InvokeHelper(null, defaultMethodName);
    }

    public InvokeHelper() {
        this(null, null);
    }

    public InvokeHelper(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public InvokeHelper(ClassLoader classLoader, String defaultMethodName) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        } else {
            ClassLoader cl = SecurityActions.getContextClassLoader();
            if (cl == null) {
                cl = SecurityActions.getClassLoader(InvokeHelper.class);
            }
            this.classLoader = cl;
        }
        this.defaultMethodName = defaultMethodName;
    }

    @Override
    public void execute(Options options) {
        Method method;
        Object instance;
        Class<?> clazz = null;
        Object methodName = this.defaultMethodName;
        if (methodName == null && (methodName = options.getHash().get("m")) == null) {
            methodName = options.getHash().get("method");
        }
        if ((instance = options.getHash().get("on")) == null && (clazz = this.loadClassIfNeeded(options)) == null) {
            instance = options.peek();
        }
        if (clazz == null) {
            clazz = instance.getClass();
        }
        if ((method = (Method)this.methodCache.get(new MethodKey(clazz, methodName.toString(), this.getParamTypes(options))).orElse(null)) == null) {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Unable to find unambiguous method with name \"%s\" and parameter types %s on class %s [%s]", methodName, this.getParamTypes(options), clazz.getName(), options.getTagInfo());
        }
        try {
            Object value = method.invoke(instance, options.getParameters().toArray());
            if (this.isSection(options)) {
                if (value != null) {
                    options.push(value);
                    options.fn();
                    options.pop();
                }
            } else {
                if (value == null) {
                    value = this.configuration.getMissingValueHandler().handle(options.getTagInfo());
                }
                if (value != null) {
                    this.convertAndAppend(options, value);
                }
            }
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void init() {
        super.init();
        this.methodCache = this.configuration.getComputingCacheFactory().create(InvokeHelper.class.getName(), new MethodComputingFunction(), null, this.configuration.getLongPropertyValue(METHOD_CACHE_MAX_SIZE_KEY), null);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(METHOD_CACHE_MAX_SIZE_KEY);
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        if (!definition.getHash().containsKey("method") && !definition.getHash().containsKey("m") && this.defaultMethodName == null) {
            throw HelperValidator.newValidationException("A method name must be always defined", this.getClass(), definition);
        }
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("on", "m", "method", "class");
    }

    private static boolean matches(Method method, List<Class<?>> paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length != paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            Class<?> type = Primitives.wrap(methodParamTypes[i]);
            if (type.isAssignableFrom(paramTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<Class<?>> getParamTypes(Options options) {
        int size = options.getParameters().size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList paramTypes = new ArrayList(size);
        for (Object param : options.getParameters()) {
            paramTypes.add(param.getClass());
        }
        return paramTypes;
    }

    private Class<?> loadClassIfNeeded(Options options) {
        Class<?> clazz = null;
        try {
            Object clazzValue = options.getHash().get("class");
            if (clazzValue != null) {
                clazz = clazzValue instanceof Class ? (Class<?>)clazzValue : this.classLoader.loadClass(clazzValue.toString());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private static List<Method> findMethods(Class<?> clazz, String name) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method method : SecurityActions.getMethods(clazz)) {
            if (!name.equals(method.getName())) continue;
            found.add(method);
        }
        return found;
    }

    private static class MethodComputingFunction
    implements ComputingCache.Function<MethodKey, Optional<Method>> {
        private MethodComputingFunction() {
        }

        @Override
        public Optional<Method> compute(MethodKey key) {
            List found = InvokeHelper.findMethods(key.getClazz(), key.getName());
            if (found.isEmpty()) {
                return Optional.empty();
            }
            found.removeIf(method -> !InvokeHelper.matches(method, key.getParamTypes()));
            if (found.size() == 1) {
                Method method2 = (Method)found.get(0);
                if (!(Modifier.isPublic(method2.getModifiers()) && Modifier.isPublic(method2.getDeclaringClass().getModifiers()) || method2.isAccessible())) {
                    SecurityActions.setAccessible(method2);
                }
                return Optional.of(method2);
            }
            return Optional.empty();
        }
    }

    private static final class MethodKey {
        private final Class<?> clazz;
        private final String name;
        private final List<Class<?>> paramTypes;

        private MethodKey(Class<?> clazz, String name, List<Class<?>> paramTypes) {
            this.clazz = clazz;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        Class<?> getClazz() {
            return this.clazz;
        }

        String getName() {
            return this.name;
        }

        List<Class<?>> getParamTypes() {
            return this.paramTypes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.paramTypes == null ? 0 : this.paramTypes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.paramTypes == null ? other.paramTypes != null : !this.paramTypes.equals(other.paramTypes));
        }
    }
}

