/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagType;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.util.Arrays;
import org.trimou.util.Checker;

public final class HelperValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelperValidator.class);

    private HelperValidator() {
    }

    public static void checkParams(Class<? extends Helper> helperClazz, HelperDefinition definition, int paramSize) {
        Checker.checkArgumentNotNull(definition);
        Checker.checkArgument(paramSize >= 0, "Helper may only require zero or more params");
        int size = definition.getParameters().size();
        if (size < paramSize) {
            throw HelperValidator.newValidationException(String.format("Insufficient number of parameters - expected: %s, current: %s", paramSize, size), helperClazz, definition);
        }
        if (size > paramSize) {
            LOGGER.trace("{} superfluous parameters detected [helper: {}, template: {}, line: {}]", new Object[]{size - paramSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static void checkType(Class<? extends Helper> helperClazz, HelperDefinition definition, MustacheTagType ... allowedTypes) {
        Checker.checkArgumentsNotNull(new Object[]{definition, allowedTypes});
        if (!Arrays.contains((Object[])allowedTypes, (Object)definition.getTagInfo().getType())) {
            throw HelperValidator.newValidationException("Unsupported tag type", helperClazz, definition);
        }
    }

    public static void checkHash(Class<? extends Helper> helperClazz, HelperDefinition definition, int hashSize) {
        Checker.checkArgumentNotNull(definition);
        Checker.checkArgument(hashSize >= 0, "Helper may only require zero or more hash entries");
        int size = definition.getHash().size();
        if (size < hashSize) {
            throw HelperValidator.newValidationException(String.format("Insufficient number of hash entries - expected: %s, current: %s", hashSize, size), helperClazz, definition);
        }
        if (size > hashSize) {
            LOGGER.trace("{} superfluous hash entries detected [helper: {}, template: {}, line: {}]", new Object[]{size - hashSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static void checkHash(HelperDefinition definition, BasicHelper helper) {
        HelperValidator.checkHash(helper.getClass(), definition, helper.numberOfRequiredHashEntries());
        if (!helper.getRequiredHashKeys().isEmpty()) {
            for (String key : helper.getRequiredHashKeys()) {
                if (definition.getHash().containsKey(key)) continue;
                throw HelperValidator.newValidationException(String.format("Required hash key %s not found", key), helper.getClass(), definition);
            }
        }
        if (definition.getHash().isEmpty() || BasicHelper.ANY_HASH_KEY_SUPPORTED.equals(helper.getSupportedHashKeys())) {
            return;
        }
        Set<String> supportedHashKeys = helper.getSupportedHashKeys();
        for (String key : definition.getHash().keySet()) {
            if (supportedHashKeys.contains(key)) continue;
            LOGGER.info("Unsupported hash key detected [key: {}, helper: {}, template: {}, line: {}]", new Object[]{key, helper.getClass().getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static MustacheException newValidationException(String msg, Class<? extends Helper> helperClazz, HelperDefinition definition) {
        return new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, msg + " [helper: %s, template: %s, line: %s]", helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
    }
}

