/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.convert.ValueConverter;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.ValueProvider;
import org.trimou.engine.text.TextSupport;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.lambda.Lambda;

@Internal
public class ValueSegment
extends AbstractSegment
implements HelperAwareSegment {
    private final boolean unescape;
    private final TextSupport textSupport;
    private final HelperExecutionHandler helperHandler;
    private final ValueProvider provider;
    private final List<ValueConverter> converters;

    public ValueSegment(String text, Origin origin, boolean unescape) {
        super(text, origin);
        this.unescape = unescape;
        HelperExecutionHandler helperExecutionHandler = this.helperHandler = this.isHandlebarsSupportEnabled() ? HelperExecutionHandler.from(text, this.getEngine(), this) : null;
        if (this.helperHandler == null) {
            this.textSupport = this.getEngineConfiguration().getTextSupport();
            this.provider = new ValueProvider(text, this.getEngineConfiguration());
            this.converters = this.getEngineConfiguration().getValueConverters().isEmpty() ? null : this.getEngineConfiguration().getValueConverters();
        } else {
            this.textSupport = null;
            this.provider = null;
            this.converters = null;
        }
    }

    @Override
    public SegmentType getType() {
        return SegmentType.VALUE;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        if (this.helperHandler != null) {
            return this.helperHandler.execute(appendable, context);
        }
        ValueWrapper value = this.provider.get(context);
        try {
            if (value.isNull()) {
                Object replacement = this.getEngineConfiguration().getMissingValueHandler().handle(this.getTagInfo());
                if (replacement != null) {
                    this.processValue(appendable, context, replacement);
                }
            } else {
                this.processValue(appendable, context, value.get());
            }
        }
        finally {
            value.release();
        }
        return appendable;
    }

    @Override
    public Appendable fn(Appendable appendable, ExecutionContext context) {
        return appendable;
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    @Override
    protected MustacheTagType getTagType() {
        return this.unescape ? MustacheTagType.UNESCAPE_VARIABLE : MustacheTagType.VARIABLE;
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            this.writeValue(appendable, this.convertValue(value));
        }
    }

    private String convertValue(Object value) {
        if (this.converters != null) {
            for (ValueConverter converter : this.converters) {
                String result = (String)converter.convert(value);
                if (result == null) continue;
                return result;
            }
        }
        return value.toString();
    }

    private void writeValue(Appendable appendable, String text) {
        if (this.unescape) {
            this.append(appendable, text);
        } else {
            try {
                this.textSupport.appendEscapedHtml(text, appendable);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        Lambda lambda = (Lambda)value;
        String returnValue = lambda.invoke(null);
        if (returnValue == null) {
            Object replacement = this.getEngineConfiguration().getMissingValueHandler().handle(this.getTagInfo());
            if (replacement != null) {
                this.processValue(appendable, context, replacement);
                return;
            }
        } else if (!returnValue.equals("")) {
            if (lambda.isReturnValueInterpolated()) {
                StringBuilder interpolated = new StringBuilder();
                Template temp = (Template)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
                temp.getRootSegment().execute(interpolated, context);
                this.writeValue(appendable, interpolated.toString());
            } else {
                this.writeValue(appendable, returnValue);
            }
        }
    }
}

