/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.util.Checker;

@Internal
public enum SegmentType {
    ROOT(null),
    VALUE(MustacheTagType.VARIABLE),
    TEXT(null),
    SECTION(MustacheTagType.SECTION),
    INVERTED_SECTION(MustacheTagType.INVERTED_SECTION),
    COMMENT(MustacheTagType.COMMENT),
    LINE_SEPARATOR(null),
    DELIMITERS(MustacheTagType.DELIMITER),
    PARTIAL(MustacheTagType.PARTIAL),
    EXTEND(MustacheTagType.EXTEND),
    EXTEND_SECTION(MustacheTagType.EXTEND_SECTION);

    private MustacheTagType tagType;

    private SegmentType(MustacheTagType tagType) {
        this.tagType = tagType;
    }

    MustacheTagType getTagType() {
        return this.tagType;
    }

    public static SegmentType fromTag(MustacheTagType tagType) {
        Checker.checkArgumentNotNull((Object)tagType);
        for (SegmentType type : SegmentType.values()) {
            if (!tagType.equals((Object)type.getTagType())) continue;
            return type;
        }
        if (MustacheTagType.UNESCAPE_VARIABLE.equals((Object)tagType)) {
            return VALUE;
        }
        throw new IllegalStateException("Unsupported tag type");
    }
}

