/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.engine.segment.TextSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class PartialSegment
extends AbstractSegment {
    private final TextSegment indentation;
    private final AtomicReference<Template> cachedPartialTemplate;
    private volatile List<List<Segment>> cachedPartialLines;

    public PartialSegment(String text, Origin origin, String indentation) {
        super(text, origin);
        this.indentation = indentation != null ? new TextSegment(indentation, new Origin(origin.getTemplate())) : null;
        this.cachedPartialTemplate = Segments.isTemplateCachingAllowed(this.getEngineConfiguration()) ? new AtomicReference() : null;
    }

    @Override
    public SegmentType getType() {
        return SegmentType.PARTIAL;
    }

    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        Template partialTemplate = Segments.getTemplate(this.cachedPartialTemplate, this.getText(), this.getEngine(), this.getTemplate());
        if (partialTemplate == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", this.getText(), this.getOrigin());
        }
        if (this.indentation == null) {
            appendable = partialTemplate.getRootSegment().execute(appendable, context);
        } else {
            this.prependIndentation(appendable, context.setTemplateInvocation(partialTemplate), partialTemplate);
        }
        return appendable;
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(MustacheTagType.PARTIAL.getCommand() + this.getText());
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prependIndentation(Appendable appendable, ExecutionContext context, Template partialTemplate) {
        List<List<Segment>> partialLines;
        if (this.cachedPartialTemplate != null) {
            partialLines = this.cachedPartialLines;
            if (partialLines == null) {
                PartialSegment partialSegment = this;
                synchronized (partialSegment) {
                    partialLines = this.cachedPartialLines;
                    if (partialLines == null) {
                        this.cachedPartialLines = partialLines = this.getPartialLines(partialTemplate);
                    }
                }
            }
        } else {
            partialLines = this.getPartialLines(partialTemplate);
        }
        for (List list : partialLines) {
            for (Segment segment : list) {
                segment.execute(appendable, context);
            }
        }
    }

    private List<List<Segment>> getPartialLines(Template partialTemplate) {
        List<List<Segment>> partialLines = Segments.readSegmentLinesBeforeRendering(partialTemplate.getRootSegment());
        for (List<Segment> line : partialLines) {
            line.add(0, this.indentation);
        }
        return partialLines;
    }
}

