/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resource;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.engine.resource.ReleaseCallback;
import org.trimou.engine.resource.ReleaseCallbackContainer;

@Internal
public abstract class AbstractReleaseCallbackContainer
implements ReleaseCallbackContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReleaseCallbackContainer.class);
    private List<ReleaseCallback> releaseCallbacks = null;

    public void release() {
        if (this.releaseCallbacks == null) {
            return;
        }
        for (ReleaseCallback callback : this.releaseCallbacks) {
            try {
                callback.release();
            }
            catch (Exception e) {
                LOGGER.warn("Exception occured during release callback invocation:", (Throwable)e);
            }
        }
    }

    @Override
    public void registerReleaseCallback(ReleaseCallback callback) {
        if (this.releaseCallbacks == null) {
            this.releaseCallbacks = new LinkedList<ReleaseCallback>();
        }
        this.releaseCallbacks.add(callback);
    }
}

