/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Transformer;
import org.trimou.engine.resolver.i18n.LocaleAwareResolver;

public class TransformResolver
extends LocaleAwareResolver
implements Transformer {
    private String[] matchingNames;
    private final Transformer transformer;

    public TransformResolver(int priority, String ... matchNames) {
        this(priority, (Transformer)null, matchNames);
    }

    public TransformResolver(int priority, Transformer transformer, String ... matchingNames) {
        super(priority);
        if (matchingNames.length > 0) {
            this.matchingNames = matchingNames;
        }
        this.transformer = transformer;
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (this.matches(contextObject, name)) {
            return this.performTransformation(contextObject, name, context);
        }
        return null;
    }

    @Override
    public Object transform(Object contextObject, String name, ResolutionContext context) {
        return null;
    }

    protected boolean matches(Object contextObject, String name) {
        return contextObject != null && this.matches(name);
    }

    protected Object performTransformation(Object contextObject, String name, ResolutionContext context) {
        return this.transformer != null ? this.transformer.transform(contextObject, name, context) : this.transform(contextObject, name, context);
    }

    protected boolean matches(String name) {
        for (String matchingName : this.matchingNames) {
            if (!matchingName.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String matchingName(int index) {
        return this.matchingNames[index];
    }

    protected void setMatchingNames(String ... matchNames) {
        if (this.matchingNames != null) {
            throw new IllegalStateException("Matching names already set!");
        }
        this.matchingNames = matchNames;
    }
}

