/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityActions {
    SecurityActions() {
    }

    static void setAccessible(AccessibleObject accessibleObject) {
        if (System.getSecurityManager() == null) {
            accessibleObject.setAccessible(true);
        }
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return accessibleObject;
        });
    }

    static Method[] getMethods(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getMethods();
            }
        });
    }

    static Field[] getFields(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getFields();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getFields();
            }
        });
    }
}

