/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.FieldWrapper;
import org.trimou.engine.resolver.Hints;
import org.trimou.engine.resolver.ListIndexResolver;
import org.trimou.engine.resolver.MemberKey;
import org.trimou.engine.resolver.MemberWrapper;
import org.trimou.engine.resolver.MethodWrapper;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.SecurityActions;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Reflections;

public class ReflectionResolver
extends AbstractResolver {
    public static final int REFLECTION_RESOLVER_PRIORITY = Priorities.after(ListIndexResolver.LIST_RESOLVER_PRIORITY, 3);
    public static final String COMPUTING_CACHE_CONSUMER_ID = ReflectionResolver.class.getName();
    public static final ConfigurationKey MEMBER_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".memberCacheMaxSize", 10000L);
    public static final ConfigurationKey HINT_FALLBACK_ENABLED_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".hintFallbackEnabled", true);
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionResolver.class);
    private static final MemberWrapper ARRAY_GET_LENGTH = Array::getLength;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    private ComputingCache<MemberKey, Optional<MemberWrapper>> memberCache;
    private boolean hintFallbackEnabled;

    public ReflectionResolver() {
        this(REFLECTION_RESOLVER_PRIORITY);
    }

    public ReflectionResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null) {
            return null;
        }
        MemberKey key = MemberKey.newInstance(contextObject, name);
        MemberWrapper wrapper = this.memberCache != null ? (MemberWrapper)this.memberCache.get(key).orElse(null) : (MemberWrapper)ReflectionResolver.findWrapper(key).orElse(null);
        if (wrapper == null) {
            return null;
        }
        try {
            return wrapper.getValue(contextObject);
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_REFLECT_INVOCATION_ERROR, (Throwable)e);
        }
    }

    @Override
    public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
        Optional<MemberWrapper> found;
        MemberKey key = MemberKey.newInstance(contextObject, name);
        MemberWrapper wrapper = this.memberCache != null ? ((found = this.memberCache.getIfPresent(key)) != null ? found.get() : null) : (MemberWrapper)ReflectionResolver.findWrapper(key).orElse(null);
        if (wrapper != null) {
            return new ReflectionHint(key, wrapper);
        }
        return Hints.INAPPLICABLE_HINT;
    }

    @Override
    public void init() {
        long memberCacheMaxSize = this.configuration.getLongPropertyValue(MEMBER_CACHE_MAX_SIZE_KEY);
        LOGGER.debug("Initialized [memberCacheMaxSize: {}]", (Object)memberCacheMaxSize);
        if (memberCacheMaxSize > 0L) {
            this.memberCache = this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, ReflectionResolver::findWrapper, null, memberCacheMaxSize, null);
        }
        this.hintFallbackEnabled = this.configuration.getBooleanPropertyValue(HINT_FALLBACK_ENABLED_KEY);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return ImmutableSet.of(MEMBER_CACHE_MAX_SIZE_KEY, HINT_FALLBACK_ENABLED_KEY);
    }

    public void invalidateMemberCache(Predicate<Class<?>> predicate) {
        if (this.memberCache == null) {
            return;
        }
        if (predicate == null) {
            this.memberCache.clear();
        } else {
            this.memberCache.invalidate(key -> predicate.test(key.getClazz()));
        }
    }

    long getMemberCacheSize() {
        return this.memberCache != null ? this.memberCache.size() : 0L;
    }

    private static Optional<MemberWrapper> findWrapper(MemberKey key) {
        if (key.getClazz().isArray()) {
            if (key.getName().equals("length")) {
                return Optional.of(ARRAY_GET_LENGTH);
            }
            return Optional.empty();
        }
        Method foundMethod = ReflectionResolver.findMethod(key.getClazz(), key.getName());
        if (foundMethod != null) {
            if (!foundMethod.isAccessible()) {
                SecurityActions.setAccessible(foundMethod);
            }
            return Optional.of(new MethodWrapper(foundMethod));
        }
        Field foundField = ReflectionResolver.findField(key.getClazz(), key.getName());
        if (foundField != null) {
            if (!foundField.isAccessible()) {
                SecurityActions.setAccessible(foundField);
            }
            return Optional.of(new FieldWrapper(foundField));
        }
        return Optional.empty();
    }

    static Method findMethod(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Method foundMatch = null;
        Method foundGetMatch = null;
        Method foundIsMatch = null;
        for (Method method : SecurityActions.getMethods(clazz)) {
            if (!ReflectionResolver.isMethodValid(method)) continue;
            if (method.isBridge()) {
                LOGGER.debug("Skipping bridge method {}", (Object)method);
                continue;
            }
            if (name.equals(method.getName())) {
                foundMatch = method;
                continue;
            }
            if (Reflections.matchesPrefix(name, method.getName(), GET_PREFIX)) {
                foundGetMatch = method;
                continue;
            }
            if (!Reflections.matchesPrefix(name, method.getName(), IS_PREFIX)) continue;
            foundIsMatch = method;
        }
        if (foundMatch == null) {
            foundMatch = foundGetMatch != null ? foundGetMatch : foundIsMatch;
        }
        LOGGER.debug("Method for [{}] {}found on type {}: {}", new Object[]{name, foundMatch != null ? "" : "not ", clazz.getName(), foundMatch});
        return foundMatch;
    }

    static Field findField(Class<?> clazz, String name) {
        Checker.checkArgumentNotNull(clazz);
        Checker.checkArgumentNotNull(name);
        Field found = null;
        for (Field field : SecurityActions.getFields(clazz)) {
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        LOGGER.debug("Field {} {}found on type: {}", new Object[]{name, found != null ? "" : "not ", clazz.getName()});
        return found;
    }

    private static boolean isMethodValid(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !Object.class.equals(method.getDeclaringClass());
    }

    private class ReflectionHint
    implements EnhancedResolver.Hint {
        private final MemberKey key;
        private final MemberWrapper wrapper;

        ReflectionHint(MemberKey key, MemberWrapper wrapper) {
            this.key = key;
            this.wrapper = wrapper;
        }

        @Override
        public Object resolve(Object contextObject, String name, ResolutionContext context) {
            if (contextObject == null) {
                return null;
            }
            if (this.key.getClazz().equals(contextObject.getClass())) {
                try {
                    return this.wrapper.getValue(contextObject);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (ReflectionResolver.this.hintFallbackEnabled) {
                return ReflectionResolver.this.resolve(contextObject, name, context);
            }
            return null;
        }
    }
}

