/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.util.Strings;

public abstract class IndexResolver
extends AbstractResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexResolver.class);

    public IndexResolver(int priority) {
        super(priority);
    }

    protected boolean notAnIndex(String name) {
        return !this.isAnIndex(name);
    }

    protected boolean isAnIndex(String name) {
        return Strings.containsOnlyDigits(name);
    }

    protected Integer getIndexValue(String name, int maxSize) {
        return this.getIndexValue(name, null, maxSize);
    }

    protected Integer getIndexValue(String name, String key, int maxSize) {
        Integer index;
        try {
            index = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Index '{}' is not a valid integer value, key: '{}'", (Object)name, (Object)(key != null ? key : "n/a"));
            return null;
        }
        if (index < 0 || index >= maxSize) {
            LOGGER.warn("Trying to access index {} but the list/array has only {} elements, key: '{}'", new Object[]{index, maxSize, key != null ? key : "n/a"});
            return null;
        }
        return index;
    }
}

