/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.IndexResolver;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.validation.Validateable;

public class CombinedIndexResolver
extends IndexResolver
implements Validateable {
    public static final int INDEX_RESOLVER_PRIORITY = Priorities.after(MapResolver.MAP_RESOLVER_PRIORITY, 3);
    private boolean isEnabled;
    public static final ConfigurationKey ENABLED_KEY = new SimpleConfigurationKey(CombinedIndexResolver.class.getName() + ".enabled", true);

    public CombinedIndexResolver() {
        this(INDEX_RESOLVER_PRIORITY);
    }

    public CombinedIndexResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        Integer index;
        if (contextObject == null || this.notAnIndex(name)) {
            return null;
        }
        if (contextObject instanceof List) {
            List list = (List)contextObject;
            Integer index2 = this.getIndexValue(name, context.getKey(), list.size());
            if (index2 != null) {
                return list.get(index2);
            }
        }
        if (contextObject.getClass().isArray() && (index = this.getIndexValue(name, context.getKey(), Array.getLength(contextObject))) != null) {
            return Array.get(contextObject, index);
        }
        return null;
    }

    @Override
    public void init(Configuration configuration) {
        this.isEnabled = configuration.getBooleanPropertyValue(ENABLED_KEY);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(ENABLED_KEY);
    }

    @Override
    public boolean isValid() {
        return this.isEnabled;
    }
}

