/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.cache;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;

public class DefaultComputingCacheFactory
extends AbstractConfigurationAware
implements ComputingCacheFactory {
    private final MaxSizeStrategy maxSizeStrategy;

    public DefaultComputingCacheFactory() {
        this(MaxSizeStrategy.CLEAR);
    }

    public DefaultComputingCacheFactory(MaxSizeStrategy maxSizeStrategy) {
        Checker.checkArgumentNotNull((Object)maxSizeStrategy);
        this.maxSizeStrategy = maxSizeStrategy;
    }

    @Override
    public <K, V> ComputingCache<K, V> create(String consumerId, ComputingCache.Function<K, V> computingFunction, Long expirationTimeout, Long maxSize, ComputingCache.Listener<K> listener) {
        if (maxSize != null && !this.maxSizeStrategy.isEvictionSupported()) {
            throw new IllegalArgumentException("Max size limit not supported - use a different eviction strategy");
        }
        return new ConcurrentHashMapAdapter<K, V>(computingFunction, maxSize, this.maxSizeStrategy, expirationTimeout, listener);
    }

    private static class CacheEntry<T> {
        private final Long createdAt;
        private final T value;

        static <T> CacheEntry<T> of(T value) {
            return new CacheEntry<T>(System.currentTimeMillis(), value);
        }

        private CacheEntry(Long createdTs, T value) {
            this.createdAt = createdTs;
            this.value = value;
        }

        boolean isExpired(Long expirationTimeout) {
            return expirationTimeout != null && System.currentTimeMillis() - this.createdAt >= expirationTimeout;
        }
    }

    private static class MaxSizeExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MaxSizeExceededException() {
        }
    }

    public static enum RemovalCause {
        EXPIRED,
        MAX_SIZE_EXCEEDED,
        INVALIDATE;

    }

    public static enum MaxSizeStrategy {
        NOOP(false),
        CLEAR(true);

        private boolean isEvictionSupported;

        private MaxSizeStrategy(boolean isEvictionSupported) {
            this.isEvictionSupported = isEvictionSupported;
        }

        public boolean isEvictionSupported() {
            return this.isEvictionSupported;
        }
    }

    private static class ConcurrentHashMapAdapter<K, V>
    implements ComputingCache<K, V> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentHashMapAdapter.class);
        private final MaxSizeStrategy maxSizeStrategy;
        private final Long maxSize;
        private final Long expirationTimeout;
        private final ComputingCache.Listener<K> listener;
        private final ConcurrentHashMap<K, CacheEntry<V>> map = new ConcurrentHashMap();
        private final Function<K, CacheEntry<V>> computingFunctionAdapter;

        ConcurrentHashMapAdapter(ComputingCache.Function<K, V> computingFunction, Long maxSize, MaxSizeStrategy maxSizeStrategy, Long expirationTimeout, ComputingCache.Listener<K> listener) {
            this.maxSize = maxSize;
            this.expirationTimeout = expirationTimeout;
            this.listener = listener;
            this.computingFunctionAdapter = key -> {
                if (maxSize != null && (long)this.map.size() > maxSize) {
                    throw new MaxSizeExceededException();
                }
                return CacheEntry.of(computingFunction.compute(key));
            };
            this.maxSizeStrategy = maxSizeStrategy;
        }

        @Override
        public V get(K key) {
            CacheEntry<V> entry = this.compute(key);
            if (entry.isExpired(this.expirationTimeout)) {
                if (this.map.remove(key) != null) {
                    this.notifyListener(key, RemovalCause.EXPIRED);
                }
                entry = this.compute(key);
            }
            return (V)((CacheEntry)entry).value;
        }

        @Override
        public V getIfPresent(K key) {
            CacheEntry<V> entry = this.map.get(key);
            if (entry != null) {
                if (entry.isExpired(this.expirationTimeout)) {
                    if (this.map.remove(key) != null) {
                        this.notifyListener(key, RemovalCause.EXPIRED);
                    }
                } else {
                    return (V)((CacheEntry)entry).value;
                }
            }
            return null;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public long size() {
            return this.map.size();
        }

        @Override
        public void invalidate(ComputingCache.KeyPredicate<K> predicate) {
            Iterator iterator = ((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (!predicate.apply(key)) continue;
                iterator.remove();
                this.notifyListener(key, RemovalCause.INVALIDATE);
            }
        }

        @Override
        public Map<K, V> getAllPresent() {
            ImmutableMap.ImmutableMapBuilder<K, Object> builder = ImmutableMap.builder();
            for (Map.Entry<K, CacheEntry<V>> entry : this.map.entrySet()) {
                if (entry.getValue().isExpired(this.expirationTimeout)) continue;
                builder.put(entry.getKey(), ((CacheEntry)entry.getValue()).value);
            }
            return builder.build();
        }

        private void notifyListener(K key, RemovalCause cause) {
            if (this.listener != null) {
                this.listener.entryInvalidated(key, cause.toString());
            }
        }

        private CacheEntry<V> compute(K key) {
            try {
                return this.map.computeIfAbsent(key, this.computingFunctionAdapter);
            }
            catch (MaxSizeExceededException e) {
                this.handleMaxSizeExceeding();
                return this.map.computeIfAbsent(key, this.computingFunctionAdapter);
            }
        }

        private synchronized void handleMaxSizeExceeding() {
            if ((long)this.map.size() > this.maxSize) {
                this.applyMaxSizeStrategy();
            }
        }

        private void applyMaxSizeStrategy() {
            switch (this.maxSizeStrategy) {
                case CLEAR: {
                    LOGGER.debug("Max size limit of {} exceeded - removing all entries from the cache", (Object)this.maxSize);
                    if (this.listener != null) {
                        HashSet keys = new HashSet(this.map.keySet());
                        this.map.clear();
                        for (Object key : keys) {
                            this.notifyListener(key, RemovalCause.MAX_SIZE_EXCEEDED);
                        }
                        break;
                    }
                    this.map.clear();
                    break;
                }
                default: {
                    LOGGER.warn("Max size limit of {} exceeded but the eviction strategy {} is not implemented!", (Object)this.maxSize, (Object)this.maxSizeStrategy);
                }
            }
        }
    }
}

