/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.lambda.i18n;

import java.util.ResourceBundle;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.lambda.InputProcessingLambda;

public class ResourceBundleLambda
extends InputProcessingLambda
implements MustacheEngineBuilder.EngineBuiltCallback {
    private String baseName;
    private LocaleSupport localeSupport;

    public ResourceBundleLambda(String baseName) {
        this.baseName = baseName;
    }

    public ResourceBundleLambda(String baseName, LocaleSupport localeSupport) {
        this.baseName = baseName;
        this.localeSupport = localeSupport;
    }

    @Override
    public String invoke(String text) {
        if (this.localeSupport == null) {
            throw new IllegalStateException("ResourceBundleLambda requires a LocaleSupport instance to work properly");
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, this.localeSupport.getCurrentLocale());
        if (bundle.containsKey(text)) {
            return bundle.getObject(text).toString();
        }
        return "";
    }

    @Override
    public boolean isReturnValueInterpolated() {
        return false;
    }

    @Override
    public void engineBuilt(MustacheEngine engine) {
        this.localeSupport = engine.getConfiguration().getLocaleSupport();
    }
}

