/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.handlebars.i18n.AbstractTimeFormatHelper;

public class TimeFormatHelper
extends AbstractTimeFormatHelper<TemporalAccessor, FormatStyle> {
    private ComputingCache<CacheKey, DateTimeFormatter> formatterCache;

    @Override
    protected void init() {
        super.init();
        this.formatterCache = this.configuration.getComputingCacheFactory().create("todo", key -> {
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            if (key.getPattern() != null) {
                builder.appendPattern(key.getPattern());
            } else if (key.getStyle() != null) {
                builder.appendLocalized(key.getStyle(), key.getStyle());
            }
            return builder.toFormatter(key.getLocale()).withZone(key.getTimeZone().toZoneId());
        }, null, null, null);
    }

    @Override
    protected String defaultFormat(TemporalAccessor value, Locale locale, TimeZone timeZone) {
        return this.format(value, FormatStyle.MEDIUM, locale, timeZone);
    }

    @Override
    protected String format(TemporalAccessor value, FormatStyle style, Locale locale, TimeZone timeZone) {
        return this.formatterCache.get(new CacheKey(locale, timeZone, null, style)).format(value);
    }

    @Override
    protected String format(TemporalAccessor value, String pattern, Locale locale, TimeZone timeZone) {
        return this.formatterCache.get(new CacheKey(locale, timeZone, pattern, null)).format(value);
    }

    @Override
    protected FormatStyle parseStyle(String style, MustacheTagInfo tagInfo) {
        try {
            return FormatStyle.valueOf(style.toUpperCase());
        }
        catch (Exception e) {
            throw this.unknownStyle(style, tagInfo);
        }
    }

    @Override
    protected TemporalAccessor getFormattableObject(Object value, Locale locale, TimeZone timeZone, MustacheTagInfo tagInfo) {
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (value instanceof Date) {
            return LocalDateTime.ofInstant(((Date)value).toInstant(), timeZone.toZoneId());
        }
        if (value instanceof Calendar) {
            return LocalDateTime.ofInstant(((Calendar)value).toInstant(), timeZone.toZoneId());
        }
        if (value instanceof Number) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), timeZone.toZoneId());
        }
        throw this.valueNotAFormattableObject(value, tagInfo);
    }

    private static final class CacheKey {
        private final Locale locale;
        private final TimeZone timeZone;
        private final String pattern;
        private final FormatStyle style;

        public CacheKey(Locale locale, TimeZone timeZone, String pattern, FormatStyle style) {
            this.locale = locale;
            this.timeZone = timeZone;
            this.pattern = pattern;
            this.style = style;
        }

        protected Locale getLocale() {
            return this.locale;
        }

        protected TimeZone getTimeZone() {
            return this.timeZone;
        }

        protected String getPattern() {
            return this.pattern;
        }

        protected FormatStyle getStyle() {
            return this.style;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
            result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            if (this.timeZone == null ? other.timeZone != null : !this.timeZone.equals(other.timeZone)) {
                return false;
            }
            if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
                return false;
            }
            return this.style == other.style;
        }
    }
}

