/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.segment.ImmutableIterationMeta;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Function;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableSet;
import org.trimou.util.Iterables;

public class EachHelper
extends BasicSectionHelper {
    public static final String SKIP_RESULT = "org.trimou.handlebars.skipResult";
    private static final String SKIP_IF_NULL = "skipIfNull";
    private static final String SKIP_UNLESS = "skipUnless:";
    private static final String SKIP_IF = "skipIf:";
    private static final String MAP = "map:";
    private static final Function SKIP_NULL_FUNC = e -> e != null ? e : SKIP_RESULT;
    private String iterationMetadataAlias;
    private ReflectionResolver reflectionResolver;

    @Override
    public void init() {
        super.init();
        this.iterationMetadataAlias = this.configuration.getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS);
    }

    @Override
    public void execute(Options options) {
        int numberOfParams = options.getParameters().size();
        if (numberOfParams < 2) {
            Object param;
            Object object = param = numberOfParams == 1 ? options.getParameters().get(0) : options.peek();
            if (param == null) {
                return;
            }
            this.processParameter(param, options, 1, this.getSize(param), this.isOmitMeta(options));
        } else {
            int size = 0;
            int index = 1;
            boolean omitMeta = this.isOmitMeta(options);
            ArrayList<Object> params = new ArrayList<Object>(options.getParameters());
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) {
                    iterator.remove();
                    continue;
                }
                if (!(e instanceof Iterator) && !(e instanceof Spliterator) && !(e instanceof Stream)) continue;
                omitMeta = true;
            }
            if (!omitMeta) {
                iterator = params.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    int paramSize = 0;
                    if (e != null) {
                        paramSize = this.getSize(e);
                    }
                    if (paramSize > 0) {
                        size += paramSize;
                        continue;
                    }
                    iterator.remove();
                }
            }
            if (!omitMeta && size == 0) {
                return;
            }
            for (Object e : params) {
                index = this.processParameter(e, options, index, size, omitMeta);
            }
        }
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    protected Set<String> getSupportedHashKeys() {
        return ImmutableSet.of("apply", "as", "omitMeta");
    }

    protected int processParameter(Object param, Options options, int index, int size, boolean isOmitMeta) {
        if (param instanceof Iterable) {
            return this.processIterator(((Iterable)param).iterator(), options, index, size, isOmitMeta);
        }
        if (param.getClass().isArray()) {
            return this.processArray(param, options, index, size, isOmitMeta);
        }
        if (param instanceof Iterator) {
            return this.processIterator((Iterator)param, options, index, size, true);
        }
        if (param instanceof Spliterator) {
            return this.processSpliterator((Spliterator)param, options, index, size, true);
        }
        if (param instanceof Stream) {
            return this.processSpliterator(((Stream)((Stream)param).sequential()).spliterator(), options, index, size, true);
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is nor an Iterable nor an array [%s]", param, options.getTagInfo());
    }

    private int processIterator(Iterator<?> iterator, Options options, int index, int size, boolean isOmitMeta) {
        Function function = this.initFunction(options);
        String alias = this.initValueAlias(options);
        while (iterator.hasNext()) {
            this.nextElement(options, iterator.next(), size, index++, function, alias, isOmitMeta);
        }
        return index;
    }

    private int processArray(Object array, Options options, int index, int size, boolean isOmitMeta) {
        int length = Array.getLength(array);
        Function function = this.initFunction(options);
        String alias = this.initValueAlias(options);
        for (int i = 0; i < length; ++i) {
            this.nextElement(options, Array.get(array, i), size, index++, function, alias, isOmitMeta);
        }
        return index;
    }

    private int processSpliterator(Spliterator<?> spliterator, Options options, int index, int size, boolean isOmitMeta) {
        Function function = this.initFunction(options);
        String alias = this.initValueAlias(options);
        spliterator.forEachRemaining(e -> this.nextElement(options, e, size, Integer.MIN_VALUE, function, alias, isOmitMeta));
        return Integer.MIN_VALUE;
    }

    private int getSize(Object param) {
        if (param instanceof Iterable) {
            return Iterables.size((Iterable)param);
        }
        if (param.getClass().isArray()) {
            return Array.getLength(param);
        }
        return 0;
    }

    private void nextElement(Options options, Object value, int size, int index, Function function, String valueAlias, boolean isOmitMeta) {
        ImmutableIterationMeta meta;
        if (function != null && SKIP_RESULT.equals(value = function.apply(value))) {
            return;
        }
        ImmutableIterationMeta immutableIterationMeta = isOmitMeta ? null : (meta = valueAlias != null ? new ImmutableIterationMeta(this.iterationMetadataAlias, size, index, valueAlias, value) : new ImmutableIterationMeta(this.iterationMetadataAlias, size, index));
        if (meta != null) {
            options.push(meta);
        }
        options.pushAnd(value).fnAnd().pop();
        if (meta != null) {
            options.pop();
        }
    }

    private Function initFunction(Options options) {
        Object function = options.getHash().get("apply");
        if (function == null) {
            return null;
        }
        if (function instanceof Function) {
            return (Function)function;
        }
        String functionStr = function.toString();
        if (SKIP_IF_NULL.equals(functionStr)) {
            return SKIP_NULL_FUNC;
        }
        if (functionStr.startsWith(SKIP_IF)) {
            return this.skip(functionStr, options, false);
        }
        if (function.toString().startsWith(SKIP_UNLESS)) {
            return this.skip(functionStr, options, true);
        }
        if (function.toString().startsWith(MAP)) {
            ReflectionResolver resolver = this.getReflectionResolver(functionStr, options);
            return e -> this.resolve(resolver, e, functionStr.substring(MAP.length()));
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is not a valid function [%s]", function, options.getTagInfo());
    }

    private Function skip(String funcStr, Options options, boolean unless) {
        ReflectionResolver resolver = this.getReflectionResolver(funcStr, options);
        if (unless) {
            return e -> Checker.isFalsy(this.resolve(resolver, e, funcStr.substring(SKIP_UNLESS.length()))) ? SKIP_RESULT : e;
        }
        return e -> !Checker.isFalsy(this.resolve(resolver, e, funcStr.substring(SKIP_IF.length()))) ? SKIP_RESULT : e;
    }

    private Object resolve(ReflectionResolver resolver, Object element, String key) {
        Object value = element;
        Iterator<String> iterator = this.configuration.getKeySplitter().split(key);
        while (iterator.hasNext()) {
            String keyPart = iterator.next();
            Object resolved = resolver.resolve(value, keyPart, null);
            if (resolved == null) {
                return null;
            }
            value = resolved;
        }
        return value;
    }

    private ReflectionResolver getReflectionResolver(String functionStr, Options options) {
        if (this.reflectionResolver == null) {
            for (Resolver resolver : this.configuration.getResolvers()) {
                if (!(resolver instanceof ReflectionResolver)) continue;
                this.reflectionResolver = (ReflectionResolver)resolver;
                break;
            }
        }
        if (this.reflectionResolver == null) {
            throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, "%s cannot be used - ReflectionResolver not found [%s]", functionStr, options.getTagInfo());
        }
        return this.reflectionResolver;
    }

    private String initValueAlias(Options options) {
        Object as = options.getHash().get("as");
        if (as == null) {
            return null;
        }
        return as.toString();
    }

    private boolean isOmitMeta(Options options) {
        Object value = options.getHash().get("omitMeta");
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value);
        }
        return Boolean.parseBoolean(value.toString());
    }
}

