/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.util.ImmutableList;

abstract class AbstractContainerSegment
extends AbstractSegment
implements ContainerSegment {
    private final Segment singleton;
    private final List<Segment> segments;

    protected AbstractContainerSegment(String text, Origin origin, List<Segment> segments) {
        super(text, origin);
        this.segments = segments;
        this.singleton = segments.size() == 1 ? segments.get(0) : null;
    }

    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        if (this.singleton != null) {
            appendable = this.singleton.execute(appendable, context);
        } else {
            for (Segment segment : this.segments) {
                appendable = segment.execute(appendable, context);
            }
        }
        return appendable;
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public List<Segment> getSegments() {
        return this.segments;
    }

    @Override
    public int getSegmentsSize(boolean recursive) {
        if (recursive) {
            int count = 0;
            for (Segment segment : this.segments) {
                ++count;
                if (!(segment instanceof ContainerSegment)) continue;
                count += ((ContainerSegment)segment).getSegmentsSize(true);
            }
            return count;
        }
        return this.segments.size();
    }

    @Override
    public String getContentLiteralBlock() {
        if (this.singleton != null) {
            return this.singleton.getLiteralBlock();
        }
        StringBuilder literal = new StringBuilder();
        for (Segment segment : this.segments) {
            literal.append(segment.getLiteralBlock());
        }
        return literal.toString();
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    @Override
    protected List<MustacheTagInfo> getDirectChildTags() {
        if (this.singleton != null) {
            return Collections.singletonList(this.singleton.getTagInfo());
        }
        ImmutableList.ImmutableListBuilder<MustacheTagInfo> builder = ImmutableList.builder();
        for (Segment segment : this.segments) {
            if (segment.getType().getTagType() == null) continue;
            builder.add(segment.getTagInfo());
        }
        return builder.build();
    }
}

