/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.locator.FilePathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.Files;
import org.trimou.util.Strings;

public class FileSystemTemplateLocator
extends FilePathTemplateLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemTemplateLocator.class);

    public FileSystemTemplateLocator(int priority, String rootPath) {
        this(priority, rootPath, null);
    }

    public FileSystemTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority, rootPath, suffix);
        Checker.checkArgumentNotEmpty(rootPath);
        this.checkRootDir();
    }

    @Override
    public Reader locateRealPath(String realPath) {
        try {
            File template = new File(new File(this.getRootPath()), this.addSuffix(realPath));
            if (!Files.isFileUsable(template)) {
                return null;
            }
            LOGGER.debug("Template located: {}", (Object)template.getAbsolutePath());
            return new InputStreamReader((InputStream)new FileInputStream(template), this.getDefaultFileEncoding());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }

    @Override
    protected String getRealPathSeparator() {
        return Strings.FILE_SEPARATOR;
    }

    @Override
    protected File getRootDir() {
        return new File(this.getRootPath());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int priority = 10;
        private String rootPath;
        private String suffix;

        private Builder() {
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FileSystemTemplateLocator build() {
            return new FileSystemTemplateLocator(this.priority, this.rootPath, this.suffix);
        }
    }
}

