/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.listener.AbstractStatsCollector;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.util.ImmutableMap;
import org.trimou.util.ImmutableSet;

public class SimpleStatsCollector
extends AbstractStatsCollector {
    public static final String COMPUTING_CACHE_CONSUMER_ID = SimpleStatsCollector.class.getName();
    protected ComputingCache<String, ComputingCache<Long, AtomicLong>> data;

    public SimpleStatsCollector() {
        this(null, null);
    }

    public SimpleStatsCollector(Predicate<String> templatePredicate, TimeUnit timeUnit) {
        super(templatePredicate, timeUnit);
    }

    @Override
    public void init() {
        this.data = this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, key -> this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, k -> new AtomicLong(0L), null, null, null), null, null, null);
    }

    @Override
    public void renderingStarted(MustacheRenderingEvent event) {
        if (this.isApplied(event.getMustacheName())) {
            long start = System.nanoTime();
            event.registerReleaseCallback(() -> this.data.get(event.getMustacheName()).get(this.convert(System.nanoTime() - start)).incrementAndGet());
        }
    }

    public void clearData() {
        this.data.clear();
    }

    public Map<Long, Long> getData(String templateId) {
        ComputingCache<Long, AtomicLong> templateData = this.data.getIfPresent(templateId);
        if (templateData != null) {
            return this.getImmutableTemplateData(templateData);
        }
        return null;
    }

    public Map<String, Map<Long, Long>> getData() {
        if (this.data.size() == 0L) {
            return Collections.emptyMap();
        }
        ImmutableMap.ImmutableMapBuilder<String, Map<Long, Long>> builder = ImmutableMap.builder();
        for (Map.Entry<String, ComputingCache<Long, AtomicLong>> entry : this.data.getAllPresent().entrySet()) {
            builder.put(entry.getKey(), this.getImmutableTemplateData(entry.getValue()));
        }
        return builder.build();
    }

    public SimpleStats getSimpleStats(String templateId) {
        ComputingCache<Long, AtomicLong> entry = this.data.getIfPresent(templateId);
        if (entry != null) {
            return new SimpleStats(templateId, entry.getAllPresent());
        }
        return null;
    }

    public Set<SimpleStats> getSimpleStats() {
        if (this.data.size() == 0L) {
            return Collections.emptySet();
        }
        ImmutableSet.ImmutableSetBuilder<SimpleStats> buidler = ImmutableSet.builder();
        for (Map.Entry<String, ComputingCache<Long, AtomicLong>> entry : this.data.getAllPresent().entrySet()) {
            buidler.add(new SimpleStats(entry.getKey(), entry.getValue().getAllPresent()));
        }
        return buidler.build();
    }

    private Map<Long, Long> getImmutableTemplateData(ComputingCache<Long, AtomicLong> templateData) {
        ImmutableMap.ImmutableMapBuilder<Long, Long> builder = ImmutableMap.builder();
        for (Map.Entry<Long, AtomicLong> entry : templateData.getAllPresent().entrySet()) {
            builder.put(entry.getKey(), entry.getValue().get());
        }
        return builder.build();
    }

    public class SimpleStats {
        private final String name;
        private final long executions;
        private final long totalTime;
        private final long meanTime;
        private final long minTime;
        private final long maxTime;

        SimpleStats(String name, Map<Long, AtomicLong> data) {
            this.name = name;
            long executions = 0L;
            long totalTime = 0L;
            for (Map.Entry<Long, AtomicLong> entry : data.entrySet()) {
                executions += entry.getValue().get();
                totalTime += entry.getKey() * entry.getValue().get();
            }
            this.executions = executions;
            this.totalTime = totalTime;
            this.meanTime = totalTime / executions;
            this.minTime = Collections.min(data.keySet());
            this.maxTime = Collections.max(data.keySet());
        }

        public String getName() {
            return this.name;
        }

        public long getExecutions() {
            return this.executions;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public long getMeanTime() {
            return this.meanTime;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleStats other = (SimpleStats)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return String.format("SimpleStats [name: %s, executions: %s, totalTime: %s, meanTime: %s, minTime: %s, maxTime: %s]", this.name, this.executions, this.totalTime, this.meanTime, this.minTime, this.maxTime);
        }
    }
}

