/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.ArrayList;
import java.util.Iterator;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.util.Iterables;

public class DotKeySplitter
extends AbstractConfigurationAware
implements KeySplitter {
    @Override
    public Iterator<String> split(String key) {
        if (key.equals(".") || key.equals("this") || !key.contains(".")) {
            return Iterables.singletonIterator(key);
        }
        boolean separator = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            if (this.isSeparator(key.charAt(i))) {
                if (separator) continue;
                if (buffer.length() > 0) {
                    parts.add(buffer.toString());
                    buffer = new StringBuilder();
                }
                separator = true;
                continue;
            }
            buffer.append(key.charAt(i));
            separator = false;
        }
        if (buffer.length() > 0) {
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    protected boolean isSeparator(char candidate) {
        return candidate == '.';
    }
}

