/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.Placeholder;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.segment.Segment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

final class DefaultExecutionContext
implements ExecutionContext {
    private final DefaultExecutionContext parent;
    private final Configuration configuration;
    protected final Object contextObject;
    protected final Template templateInvocation;
    protected final int invocationLimitCounter;
    protected final Map<String, Segment> definingSections;
    protected final Resolver[] resolvers;

    DefaultExecutionContext(DefaultExecutionContext parent, Configuration configuration, Object contextObject, Template templateInvocation, int invocationLimitCounter, Map<String, Segment> definingSections, Resolver[] resolvers) {
        this.parent = parent;
        this.configuration = configuration;
        this.contextObject = contextObject;
        this.templateInvocation = templateInvocation;
        this.invocationLimitCounter = invocationLimitCounter;
        this.definingSections = definingSections;
        this.resolvers = resolvers;
    }

    @Override
    public ValueWrapper getValue(String key, String[] keyParts, AtomicReference<EnhancedResolver.Hint> hintRef) {
        Object lastValue;
        ValueWrapper value = new ValueWrapper(key);
        if (keyParts == null || keyParts.length == 0) {
            Iterator<String> parts = this.configuration.getKeySplitter().split(key);
            lastValue = this.resolveLeadingContextObject(parts.next(), value, hintRef);
            if (lastValue == null) {
                return value;
            }
            while (parts.hasNext()) {
                value.processNextPart();
                if ((lastValue = this.resolve(lastValue, parts.next(), value, false)) != null) continue;
                return value;
            }
        } else {
            lastValue = this.resolveLeadingContextObject(keyParts[0], value, hintRef);
            if (lastValue == null) {
                return value;
            }
            if (keyParts.length > 1) {
                for (int i = 1; i < keyParts.length; ++i) {
                    value.processNextPart();
                    lastValue = this.resolve(lastValue, keyParts[i], value, false);
                    if (lastValue != null) continue;
                    return value;
                }
            }
        }
        if (!Placeholder.NULL.equals(lastValue)) {
            value.set(lastValue);
        }
        return value;
    }

    @Override
    public ValueWrapper getValue(String key) {
        return this.getValue(key, null, null);
    }

    @Override
    public ExecutionContext setContextObject(Object object) {
        return new DefaultExecutionContext(this, this.configuration, object, null, this.invocationLimitCounter, null, this.resolvers);
    }

    @Override
    public Object getFirstContextObject() {
        if (this.contextObject != null) {
            return this.contextObject;
        }
        if (this.parent != null) {
            return this.parent.getFirstContextObject();
        }
        return null;
    }

    @Override
    public ExecutionContext setTemplateInvocation(Template template) {
        if (this.invocationLimitCounter < 0 && this.getTemplateInvocations(template) > this.configuration.getIntegerPropertyValue(EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT)) {
            throw new MustacheException(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED, "Recursive invocation limit exceeded [limit: %s, level: %s, template: %s]", this.configuration.getIntegerPropertyValue(EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT), this.invocationLimitCounter, this.templateInvocation);
        }
        return new DefaultExecutionContext(this, this.configuration, null, template, this.invocationLimitCounter - 1, null, this.resolvers);
    }

    @Override
    public ExecutionContext setDefiningSections(Iterable<Segment> segments) {
        HashMap<String, Segment> definingSections = null;
        for (Segment segment : segments) {
            if (this.getDefiningSection(segment.getText()) != null) continue;
            if (definingSections == null) {
                definingSections = new HashMap<String, Segment>();
            }
            definingSections.put(segment.getText(), segment);
        }
        return new DefaultExecutionContext(this, this.configuration, null, null, this.invocationLimitCounter, definingSections, this.resolvers);
    }

    @Override
    public Segment getDefiningSection(String name) {
        Segment section = null;
        if (this.definingSections != null) {
            section = this.definingSections.get(name);
        }
        if (section == null && this.parent != null) {
            section = this.parent.getDefiningSection(name);
        }
        return section;
    }

    @Override
    public ExecutionContext getParent() {
        return this.parent;
    }

    private int getTemplateInvocations(Template template) {
        int invocations = 0;
        if (this.templateInvocation != null && this.templateInvocation.equals(template)) {
            ++invocations;
        }
        if (this.parent != null) {
            invocations += this.parent.getTemplateInvocations(template);
        }
        return invocations;
    }

    private Object resolveLeadingContextObject(String name, ValueWrapper value, AtomicReference<EnhancedResolver.Hint> hintRef) {
        Object leading = this.resolveContextObject(name, value, hintRef);
        if (leading == null) {
            EnhancedResolver.Hint hint;
            EnhancedResolver.Hint hint2 = hint = hintRef != null ? hintRef.get() : null;
            if (hint != null) {
                leading = hint.resolve(null, name, value);
            }
            if (leading == null) {
                leading = this.resolve(null, name, value, hint == null && hintRef != null);
            }
        }
        return leading;
    }

    private Object resolveContextObject(String name, ValueWrapper value, AtomicReference<EnhancedResolver.Hint> hintRef) {
        Object leading = null;
        if (this.contextObject != null) {
            EnhancedResolver.Hint hint;
            EnhancedResolver.Hint hint2 = hint = hintRef != null ? hintRef.get() : null;
            if (hint != null) {
                leading = hint.resolve(this.contextObject, name, value);
            }
            if (leading == null) {
                leading = this.resolve(this.contextObject, name, value, hint == null && hintRef != null);
            }
        }
        if (leading == null && this.parent != null) {
            leading = this.parent.resolveContextObject(name, value, hintRef);
        }
        return leading;
    }

    private Object resolve(Object contextObject, String name, ValueWrapper value, boolean createHint) {
        Object resolved = null;
        for (Resolver resolver : this.resolvers) {
            resolved = resolver.resolve(contextObject, name, value);
            if (resolved == null) continue;
            if (!createHint || !(resolver instanceof EnhancedResolver)) break;
            value.setHint(((EnhancedResolver)resolver).createHint(contextObject, name, value));
            break;
        }
        return resolved;
    }
}

