/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import org.trimou.util.Strings;

final class ConfigurationProperties {
    private ConfigurationProperties() {
    }

    static String buildPropertyKey(String propertyName, String[] prefixParts) {
        return ConfigurationProperties.buildPropertyKey(propertyName, "_", prefixParts);
    }

    static String buildPropertyKey(String propertyName, String delimiter, String[] prefixParts) {
        StringBuilder key = new StringBuilder();
        for (String prefixPart : prefixParts) {
            key.append(prefixPart);
            key.append(".");
        }
        key.append(Strings.uncapitalize(Strings.replace(Strings.capitalizeFully(propertyName, Character.valueOf(delimiter.toCharArray()[0])), delimiter, "")));
        return key.toString();
    }

    static Object convertConfigValue(Class<?> defaultValueType, Object value) {
        if (defaultValueType.equals(String.class)) {
            return value.toString();
        }
        if (defaultValueType.equals(Boolean.class)) {
            return Boolean.valueOf(value.toString());
        }
        if (defaultValueType.equals(Long.class)) {
            return Long.valueOf(value.toString());
        }
        if (defaultValueType.equals(Integer.class)) {
            return Integer.valueOf(value.toString());
        }
        throw new IllegalStateException("Unsupported default value type: " + defaultValueType);
    }
}

