/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.xgboost;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.tribuo.Dataset;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.classification.Label;
import org.tribuo.classification.xgboost.XGBoostClassificationConverter;
import org.tribuo.common.xgboost.XGBoostModel;
import org.tribuo.common.xgboost.XGBoostTrainer;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.provenance.impl.TrainerProvenanceImpl;

public final class XGBoostClassificationTrainer
extends XGBoostTrainer<Label> {
    private static final Logger logger = Logger.getLogger(XGBoostClassificationTrainer.class.getName());
    @Config(description="Evaluation metric to use. The default value is set based on the objective function, so this can be usually left blank.")
    private String evalMetric = "";

    public XGBoostClassificationTrainer(int numTrees) {
        this(numTrees, 0.3, 0.0, 6, 1.0, 1.0, 1.0, 1.0, 0.0, 4, true, 12345L);
    }

    public XGBoostClassificationTrainer(int numTrees, int numThreads, boolean silent) {
        this(numTrees, 0.3, 0.0, 6, 1.0, 1.0, 1.0, 1.0, 0.0, numThreads, silent, 12345L);
    }

    public XGBoostClassificationTrainer(int numTrees, double eta, double gamma, int maxDepth, double minChildWeight, double subsample, double featureSubsample, double lambda, double alpha, int nThread, boolean silent, long seed) {
        super(numTrees, eta, gamma, maxDepth, minChildWeight, subsample, featureSubsample, lambda, alpha, nThread, silent, seed);
        this.postConfig();
    }

    public XGBoostClassificationTrainer(XGBoostTrainer.BoosterType boosterType, XGBoostTrainer.TreeMethod treeMethod, int numTrees, double eta, double gamma, int maxDepth, double minChildWeight, double subsample, double featureSubsample, double lambda, double alpha, int nThread, XGBoostTrainer.LoggingVerbosity verbosity, long seed) {
        super(boosterType, treeMethod, numTrees, eta, gamma, maxDepth, minChildWeight, subsample, featureSubsample, lambda, alpha, nThread, verbosity, seed);
        this.postConfig();
    }

    public XGBoostClassificationTrainer(int numTrees, Map<String, Object> parameters) {
        super(numTrees, parameters);
        this.postConfig();
    }

    protected XGBoostClassificationTrainer() {
    }

    public void postConfig() {
        super.postConfig();
        this.parameters.put("objective", "multi:softprob");
        if (!this.evalMetric.isEmpty()) {
            this.parameters.put("eval_metric", this.evalMetric);
        }
    }

    public synchronized XGBoostModel<Label> train(Dataset<Label> examples, Map<String, Provenance> runProvenance) {
        return this.train(examples, runProvenance, -1);
    }

    public synchronized XGBoostModel<Label> train(Dataset<Label> examples, Map<String, Provenance> runProvenance, int invocationCount) {
        Booster model;
        if (examples.getOutputInfo().getUnknownCount() > 0) {
            throw new IllegalArgumentException("The supplied Dataset contained unknown Outputs, and this Trainer is supervised.");
        }
        ImmutableFeatureMap featureMap = examples.getFeatureIDMap();
        ImmutableOutputInfo outputInfo = examples.getOutputIDInfo();
        if (invocationCount != -1) {
            this.setInvocationCount(invocationCount);
        }
        TrainerProvenance trainerProvenance = this.getProvenance();
        ++this.trainInvocationCounter;
        this.parameters.put("num_class", outputInfo.size());
        Function<Label, Float> responseExtractor = l -> Float.valueOf(outputInfo.getID((Output)l));
        try {
            XGBoostTrainer.DMatrixTuple trainingData = XGBoostClassificationTrainer.convertExamples(examples, (ImmutableFeatureMap)featureMap, responseExtractor);
            model = XGBoost.train((DMatrix)trainingData.data, (Map)this.parameters, (int)this.numTrees, Collections.emptyMap(), null, null);
        }
        catch (XGBoostError e) {
            logger.log(Level.SEVERE, "XGBoost threw an error", e);
            throw new IllegalStateException(e);
        }
        ModelProvenance provenance = new ModelProvenance(XGBoostModel.class.getName(), OffsetDateTime.now(), (DatasetProvenance)examples.getProvenance(), trainerProvenance, runProvenance);
        XGBoostModel xgModel = this.createModel("xgboost-classification-model", provenance, featureMap, outputInfo, Collections.singletonList(model), new XGBoostClassificationConverter());
        return xgModel;
    }

    public TrainerProvenance getProvenance() {
        return new TrainerProvenanceImpl((Trainer)this);
    }
}

