/*
 * Decompiled with CFR 0.152.
 */
package org.toilelibre.libe.curl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.HostnameVerifier;
import javax.security.cert.CertificateException;
import org.apache.commons.cli.CommandLine;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.toilelibre.libe.curl.Arguments;
import org.toilelibre.libe.curl.CertFormat;
import org.toilelibre.libe.curl.Curl;
import org.toilelibre.libe.curl.IOUtils;

final class HttpClientProvider {
    HttpClientProvider() {
    }

    static HttpClient prepareHttpClient(CommandLine commandLine) throws Curl.CurlException {
        String hostname;
        HttpClientBuilder executor = HttpClientBuilder.create();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException(e1);
        }
        executor = HttpClientProvider.handleAuthMethod(commandLine, executor, hostname);
        if (!commandLine.hasOption(Arguments.FOLLOW_REDIRECTS.getOpt())) {
            executor.disableRedirectHandling();
        }
        HttpClientProvider.handleSSLParams(commandLine, executor);
        return executor.build();
    }

    private static void addClientCredentials(SSLContextBuilder builder, CertFormat certFormat, String caCertFilePath, String certFilePath, CertFormat keyFormat, String keyFilePath, String password) throws Curl.CurlException {
        try {
            File caCertFileObject = caCertFilePath == null ? null : HttpClientProvider.getFile(caCertFilePath);
            File certFileObject = HttpClientProvider.getFile(certFilePath);
            File keyFileObject = HttpClientProvider.getFile(keyFilePath);
            KeyStore keyStore = HttpClientProvider.generateKeyStore(certFormat, caCertFileObject, certFileObject, keyFormat, keyFileObject, password == null ? null : password.toCharArray());
            builder.loadKeyMaterial(keyStore, password == null ? null : password.toCharArray());
        }
        catch (IOException | GeneralSecurityException | CertificateException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static KeyStore generateKeyStore(CertFormat certFormat, File caCertFileObject, File certFileObject, CertFormat keyFormat, File keyFileObject, char[] passwordAsCharArray) throws KeyStoreException, NoSuchAlgorithmException, java.security.cert.CertificateException, IOException, Curl.CurlException, CertificateException {
        List caCertificatesNotFiltered = caCertFileObject == null ? Collections.emptyList() : certFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.CERTIFICATE, IOUtils.toByteArray(caCertFileObject), passwordAsCharArray);
        List caCertificatesFiltered = caCertificatesNotFiltered.stream().filter(certificate -> certificate instanceof X509Certificate && ((X509Certificate)certificate).getBasicConstraints() != -1).collect(Collectors.toList());
        List<Certificate> certificates = certFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.CERTIFICATE, IOUtils.toByteArray(certFileObject), passwordAsCharArray);
        List privateKeys = keyFormat.generateCredentialsFromFileAndPassword(CertFormat.Kind.PRIVATE_KEY, IOUtils.toByteArray(keyFileObject), passwordAsCharArray);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null);
        Certificate[] certificatesAsArray = certificates.toArray(new Certificate[certificates.size()]);
        IntStream.range(0, certificates.size()).forEach(i -> HttpClientProvider.setCertificateEntry(keyStore, certificates, i));
        IntStream.range(0, caCertificatesFiltered.size()).forEach(i -> HttpClientProvider.setCaCertificateEntry(keyStore, certificates, i));
        IntStream.range(0, privateKeys.size()).forEach(i -> HttpClientProvider.setPrivateKeyEntry(keyStore, privateKeys, passwordAsCharArray, certificatesAsArray, i));
        return keyStore;
    }

    private static File getFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        return new File(System.getProperty("user.dir") + File.separator + filePath);
    }

    private static HttpClientBuilder handleAuthMethod(CommandLine commandLine, HttpClientBuilder executor, String hostname) {
        if (commandLine.getOptionValue(Arguments.AUTH.getOpt()) != null) {
            String[] authValue = commandLine.getOptionValue(Arguments.AUTH.getOpt()).split("(?<!\\\\):");
            if (commandLine.hasOption(Arguments.NTLM.getOpt())) {
                String[] userName = authValue[0].split("\\\\");
                SystemDefaultCredentialsProvider systemDefaultCredentialsProvider = new SystemDefaultCredentialsProvider();
                systemDefaultCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(userName[1], authValue[1], hostname, userName[0]));
                executor = executor.setDefaultCredentialsProvider((CredentialsProvider)systemDefaultCredentialsProvider);
            } else {
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)URI.create(commandLine.getArgs()[0]).getHost())), (Credentials)new UsernamePasswordCredentials(authValue[0], authValue[1]));
                executor = executor.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            }
        }
        return executor;
    }

    private static void handleSSLParams(CommandLine commandLine, HttpClientBuilder executor) throws Curl.CurlException {
        CertFormat keyFormat;
        CertFormat certFormat;
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.useProtocol(HttpClientProvider.protocolFromCommandLine(commandLine));
        if (commandLine.hasOption(Arguments.TRUST_INSECURE.getOpt())) {
            HttpClientProvider.sayTrustInsecure(builder);
        }
        CertFormat certFormat2 = certFormat = commandLine.hasOption(Arguments.CERT_TYPE.getOpt()) ? CertFormat.valueOf(commandLine.getOptionValue(Arguments.CERT_TYPE.getOpt()).toUpperCase()) : CertFormat.PEM;
        CertFormat certFormat3 = commandLine.hasOption(Arguments.KEY.getOpt()) ? (commandLine.hasOption(Arguments.KEY_TYPE.getOpt()) ? CertFormat.valueOf(commandLine.getOptionValue(Arguments.KEY_TYPE.getOpt()).toUpperCase()) : CertFormat.PEM) : (keyFormat = certFormat);
        if (commandLine.hasOption(Arguments.CERT.getOpt())) {
            String[] credentials = commandLine.getOptionValue(Arguments.CERT.getOpt()).split(":");
            String cacert = commandLine.getOptionValue(Arguments.CA_CERT.getOpt()) == null ? null : commandLine.getOptionValue(Arguments.CA_CERT.getOpt());
            String key = commandLine.getOptionValue(Arguments.KEY.getOpt()) == null ? credentials[0] : commandLine.getOptionValue(Arguments.KEY.getOpt());
            HttpClientProvider.addClientCredentials(builder, certFormat, cacert, credentials[0], keyFormat, key, credentials.length > 1 ? credentials[1] : "");
        }
        try {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)(commandLine.hasOption(Arguments.TRUST_INSECURE.getOpt()) ? NoopHostnameVerifier.INSTANCE : SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
            executor.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static String protocolFromCommandLine(CommandLine commandLine) {
        if (commandLine.hasOption(Arguments.TLS_V1.getOpt())) {
            return "TLSv1";
        }
        if (commandLine.hasOption(Arguments.TLS_V10.getOpt())) {
            return "TLSv1.0";
        }
        if (commandLine.hasOption(Arguments.TLS_V11.getOpt())) {
            return "TLSv1.1";
        }
        if (commandLine.hasOption(Arguments.TLS_V12.getOpt())) {
            return "TLSv1.2";
        }
        if (commandLine.hasOption(Arguments.SSL_V2.getOpt())) {
            return "SSLv2";
        }
        if (commandLine.hasOption(Arguments.SSL_V3.getOpt())) {
            return "SSLv3";
        }
        return "TLS";
    }

    private static void sayTrustInsecure(SSLContextBuilder builder) throws Curl.CurlException {
        try {
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setCaCertificateEntry(KeyStore keyStore, List<Certificate> certificates, int i) {
        try {
            keyStore.setCertificateEntry("ca-cert-alias-" + i, certificates.get(i));
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setCertificateEntry(KeyStore keyStore, List<Certificate> certificates, int i) {
        try {
            keyStore.setCertificateEntry("cert-alias-" + i, certificates.get(i));
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }

    private static void setPrivateKeyEntry(KeyStore keyStore, List<PrivateKey> privateKeys, char[] passwordAsCharArray, Certificate[] certificatesAsArray, int i) {
        try {
            keyStore.setKeyEntry("key-alias-" + i, privateKeys.get(i), passwordAsCharArray, certificatesAsArray);
        }
        catch (KeyStoreException e) {
            throw new Curl.CurlException(e);
        }
    }
}

