/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.togglz.core.Feature;
import org.togglz.core.proxy.FeatureProxyInvocationHandler;
import org.togglz.core.util.NamedFeature;
import org.togglz.core.util.Validate;

public class FeatureProxyFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    private String feature;
    private Object active;
    private Object inactive;
    private Class<?> proxyType;
    private boolean initialized = false;

    public void afterPropertiesSet() throws Exception {
        Validate.notBlank((String)this.feature, (String)"The 'feature' property is required");
        Validate.notNull((Object)this.active, (String)"The 'active' property is required");
        Validate.notNull((Object)this.inactive, (String)"The 'inactive' property is required");
        if (this.proxyType != null && !this.proxyType.isInterface()) {
            throw new IllegalArgumentException(this.proxyType.getClass().getName() + " is not an interface");
        }
        this.initialized = true;
    }

    public Object getObject() throws Exception {
        if (!this.initialized) {
            throw new FactoryBeanNotInitializedException();
        }
        NamedFeature namedFeature = new NamedFeature(this.feature);
        FeatureProxyInvocationHandler proxy = new FeatureProxyInvocationHandler((Feature)namedFeature, this.active, this.inactive);
        Class<?> proxyType = this.getEffectiveProxyType();
        return Proxy.newProxyInstance(this.getSuitableClassLoader(), new Class[]{proxyType}, (InvocationHandler)proxy);
    }

    private Class<?> getEffectiveProxyType() {
        if (this.proxyType != null) {
            return this.proxyType;
        }
        HashSet activeInterfaces = new HashSet(Arrays.asList(this.active.getClass().getInterfaces()));
        HashSet inactiveInterfaces = new HashSet(Arrays.asList(this.inactive.getClass().getInterfaces()));
        activeInterfaces.retainAll(inactiveInterfaces);
        if (activeInterfaces.size() != 1) {
            throw new IllegalArgumentException("The active and the inactive class must share exactly one interface");
        }
        return activeInterfaces.iterator().next();
    }

    private ClassLoader getSuitableClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    public Class<?> getObjectType() {
        if (this.initialized) {
            return this.getEffectiveProxyType();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public Object getActive() {
        return this.active;
    }

    public void setActive(Object active) {
        this.active = active;
    }

    public Object getInactive() {
        return this.inactive;
    }

    public void setInactive(Object inactive) {
        this.inactive = inactive;
    }

    public Class<?> getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(Class<?> proxyType) {
        this.proxyType = proxyType;
    }
}

