/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class CachingStateRepository
implements StateRepository {
    private final StateRepository delegate;
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private long ttl;

    public CachingStateRepository(StateRepository delegate) {
        this(delegate, 0L);
    }

    public CachingStateRepository(StateRepository delegate, long ttl) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("Negative TTL value: " + ttl);
        }
        this.delegate = delegate;
        this.ttl = ttl;
    }

    public CachingStateRepository(StateRepository delegate, long ttl, TimeUnit ttlTimeUnit) {
        this(delegate, ttlTimeUnit.toMillis(ttl));
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        CacheEntry entry = this.cache.get(feature.name());
        if (entry != null && !this.isExpired(entry)) {
            return entry.getState() != null ? entry.getState().copy() : null;
        }
        FeatureState featureState = this.delegate.getFeatureState(feature);
        this.cache.put(feature.name(), new CacheEntry(featureState != null ? featureState.copy() : null));
        return featureState;
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        this.delegate.setFeatureState(featureState);
        this.cache.remove(featureState.getFeature().name());
    }

    private boolean isExpired(CacheEntry entry) {
        if (this.ttl == 0L) {
            return false;
        }
        return entry.getTimestamp() + this.ttl < System.currentTimeMillis();
    }

    private static class CacheEntry {
        private final FeatureState state;
        private final long timestamp;

        public CacheEntry(FeatureState state) {
            this.state = state;
            this.timestamp = System.currentTimeMillis();
        }

        public FeatureState getState() {
            return this.state;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

