/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.togglz.core.logging.Log;
import org.togglz.core.spi.LogProvider;

public class Jdk14LogProvider
implements LogProvider {
    @Override
    public int priority() {
        return 1000;
    }

    @Override
    public Log getLog(String name) {
        return new Jdk14Log(name);
    }

    public static class Jdk14Log
    implements Log {
        private final Logger logger;

        public Jdk14Log(String name) {
            this.logger = Logger.getLogger(name);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            this.logger.fine(msg);
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void error(String msg) {
            this.logger.severe(msg);
        }

        @Override
        public void error(String msg, Throwable e) {
            this.logger.log(Level.SEVERE, msg, e);
        }
    }
}

