/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.template;

import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.togglz.console.shade.asm.ClassVisitor;
import org.togglz.console.shade.asm.ClassWriter;
import org.togglz.console.shade.asm.Label;
import org.togglz.console.shade.asm.MethodVisitor;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.console.shade.jmte.template.Template;
import org.togglz.console.shade.jmte.template.TemplateCompiler;
import org.togglz.console.shade.jmte.token.AnnotationToken;
import org.togglz.console.shade.jmte.token.ElseToken;
import org.togglz.console.shade.jmte.token.EndToken;
import org.togglz.console.shade.jmte.token.ForEachToken;
import org.togglz.console.shade.jmte.token.IfCmpToken;
import org.togglz.console.shade.jmte.token.IfToken;
import org.togglz.console.shade.jmte.token.InvalidToken;
import org.togglz.console.shade.jmte.token.PlainTextToken;
import org.togglz.console.shade.jmte.token.StringToken;
import org.togglz.console.shade.jmte.token.Token;
import org.togglz.console.shade.jmte.token.TokenStream;
import org.togglz.console.shade.jmte.util.UniqueNameGenerator;

public class DynamicBytecodeCompiler
implements TemplateCompiler {
    private static final String COMPILED_TEMPLATE_NAME_PREFIX = "org/togglz/console/shade/jmte/template/CompiledTemplate";
    private static final int THIS = 0;
    private static final int CONTEXT = 1;
    private static final int BUFFER = 2;
    private static final int EXCEPTION = 3;
    private static final int HIGHEST = 3;
    private final DelegatingClassLoader cloadLoader = new DelegatingClassLoader(DynamicBytecodeCompiler.class.getClassLoader());
    private final UniqueNameGenerator<String, String> uniqueNameGenerator = new UniqueNameGenerator("org/togglz/console/shade/jmte/template/CompiledTemplate");
    protected transient Set<String> usedVariables;
    protected final List<String> localVarStack = new LinkedList<String>();
    protected transient ClassVisitor classVisitor;
    protected transient ClassWriter classWriter;
    protected final String superClassName = "org/togglz/console/shade/jmte/template/AbstractCompiledTemplate";
    protected transient String className;
    protected transient String typeDescriptor;
    protected transient StringWriter writer;
    protected transient MethodVisitor mv;
    protected transient Label startLabel = new Label();
    protected transient Label endLabel = new Label();
    protected transient TokenStream tokenStream;
    protected transient int tokenLocalVarIndex = 4;
    protected transient Engine engine;

    protected <T> Class<T> loadClass(byte[] b, Class<T> type) {
        return this.cloadLoader.defineClass(null, b);
    }

    protected Class<?> loadClass(byte[] b) {
        return this.cloadLoader.defineClass(null, b);
    }

    private void initCompilation() {
        this.usedVariables = new TreeSet<String>();
        this.localVarStack.clear();
        this.className = this.uniqueNameGenerator.nextUniqueName();
        this.typeDescriptor = "L" + this.className + ";";
        this.classWriter = new ClassWriter(2);
        this.classVisitor = this.classWriter;
    }

    private void addUsedVariableIfNotLocal(String variableName) {
        if (!this.localVarStack.contains(variableName)) {
            this.usedVariables.add(variableName);
        }
    }

    private void foreach() {
        Token contentToken;
        ForEachToken feToken = (ForEachToken)this.tokenStream.currentToken();
        this.tokenStream.consume();
        this.localVarStack.add(0, feToken.getVarName());
        Label loopStart = new Label();
        Label loopEnd = new Label();
        Label tryEndLabel = new Label();
        this.codeGenerateForeachBlockStart(feToken, loopStart, loopEnd, tryEndLabel);
        this.addUsedVariableIfNotLocal(feToken.getExpression());
        while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
            this.content();
        }
        if (contentToken == null) {
            this.engine.getErrorHandler().error("missing-end", feToken);
        } else {
            this.tokenStream.consume();
        }
        this.codeGenerateForeachBlockEnd(loopStart, loopEnd, tryEndLabel);
        this.localVarStack.remove(0);
    }

    private void condition() {
        Token contentToken;
        IfToken ifToken = (IfToken)this.tokenStream.currentToken();
        this.tokenStream.consume();
        Label tryEndLabel = new Label();
        Label finalLabel = new Label();
        Label elseLabel = new Label();
        this.codeGenerateIfBlockStart(ifToken, tryEndLabel, elseLabel);
        String variableName = ifToken.getExpression();
        this.addUsedVariableIfNotLocal(variableName);
        this.codeGenerateIfBranchStart();
        while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken) && !(contentToken instanceof ElseToken)) {
            this.content();
        }
        this.codeGenerateIfBranchEnd(finalLabel);
        this.codeGenerateElseBranchStart(elseLabel);
        if (contentToken instanceof ElseToken) {
            this.tokenStream.consume();
            while ((contentToken = this.tokenStream.currentToken()) != null && !(contentToken instanceof EndToken)) {
                this.content();
            }
        }
        this.codeGenerateElseBranchEnd(finalLabel);
        if (contentToken == null) {
            this.engine.getErrorHandler().error("missing-end", ifToken);
        } else {
            this.tokenStream.consume();
        }
        this.codeGenerateIfBlockEnd(tryEndLabel, finalLabel);
    }

    private void content() {
        Token token = this.tokenStream.currentToken();
        if (token instanceof PlainTextToken) {
            PlainTextToken plainTextToken = (PlainTextToken)token;
            this.tokenStream.consume();
            String text = plainTextToken.getText();
            this.codeGenerateText(text);
        } else if (token instanceof StringToken) {
            StringToken stringToken = (StringToken)token;
            this.tokenStream.consume();
            String variableName = stringToken.getExpression();
            this.addUsedVariableIfNotLocal(variableName);
            this.codeGenerateStringToken(stringToken);
        } else if (token instanceof ForEachToken) {
            this.foreach();
        } else if (token instanceof IfToken) {
            this.condition();
        } else if (token instanceof ElseToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("else-out-of-scope", token);
        } else if (token instanceof EndToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("unmatched-end", token, null);
        } else if (token instanceof InvalidToken) {
            this.tokenStream.consume();
            this.engine.getErrorHandler().error("invalid-expression", token, null);
        } else if (token instanceof AnnotationToken) {
            this.tokenStream.consume();
            this.codeGenerateAnnotationToken((AnnotationToken)token);
        } else {
            this.tokenStream.consume();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Template compile(String template, String sourceName, Engine engine) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createCtor() {
        MethodVisitor mv = this.classVisitor.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/template/AbstractCompiledTemplate", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void closeCompilation() {
        this.returnStringBuilder();
        this.mv.visitLabel(this.endLabel);
        this.mv.visitMaxs(1, 1);
        this.mv.visitEnd();
    }

    private void createStringBuilder() {
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        this.mv.visitVarInsn(58, 2);
    }

    private void returnStringBuilder() {
        this.mv.visitVarInsn(25, 2);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        this.mv.visitInsn(176);
    }

    private void pushConstant(String parameter) {
        if (parameter != null) {
            this.mv.visitLdcInsn(parameter);
        } else {
            this.mv.visitInsn(1);
        }
    }

    private void openCompilation() {
        this.classVisitor.visit(50, 33, this.className, null, "org/togglz/console/shade/jmte/template/AbstractCompiledTemplate", null);
        this.createCtor();
        this.mv = this.classVisitor.visitMethod(4, "transformCompiled", "(Lcom/floreysoft/jmte/TemplateContext;)Ljava/lang/String;", null, null);
        this.mv.visitCode();
        this.mv.visitLabel(this.startLabel);
        this.createStringBuilder();
    }

    private void codeGenerateAnnotationToken(AnnotationToken annotationToken) {
        this.mv.visitVarInsn(25, 2);
        this.mv.visitTypeInsn(187, "org/togglz/console/shade/jmte/token/AnnotationToken");
        this.mv.visitInsn(89);
        this.pushConstant(annotationToken.getReceiver());
        this.pushConstant(annotationToken.getArguments());
        this.mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/token/AnnotationToken", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/AnnotationToken", "evaluate", "(Lcom/floreysoft/jmte/TemplateContext;)Ljava/lang/Object;");
        this.mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.mv.visitInsn(87);
    }

    private void codeGenerateStringToken(StringToken stringToken) {
        this.mv.visitVarInsn(25, 2);
        this.mv.visitTypeInsn(187, "org/togglz/console/shade/jmte/token/StringToken");
        this.mv.visitInsn(89);
        this.pushConstant(stringToken.getExpression());
        this.pushList(stringToken.getSegments());
        this.pushConstant(stringToken.getExpression());
        this.pushConstant(stringToken.getDefaultValue());
        this.pushConstant(stringToken.getPrefix());
        this.pushConstant(stringToken.getSuffix());
        this.pushConstant(stringToken.getRendererName());
        this.pushConstant(stringToken.getParameters());
        this.mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/token/StringToken", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/StringToken", "evaluate", "(Lcom/floreysoft/jmte/TemplateContext;)Ljava/lang/Object;");
        this.mv.visitMethodInsn(182, "java/lang/Object", "toString", "()Ljava/lang/String;");
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.mv.visitInsn(87);
    }

    private void codeGenerateText(String text) {
        this.mv.visitVarInsn(25, 2);
        this.pushConstant(text);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.mv.visitInsn(87);
    }

    private void codeGenerateElseBranchStart(Label elseLabel) {
        this.mv.visitLabel(elseLabel);
    }

    private void codeGenerateElseBranchEnd(Label finalLabel) {
        this.mv.visitJumpInsn(167, finalLabel);
    }

    private void codeGenerateIfBranchStart() {
    }

    private void codeGenerateIfBranchEnd(Label finalLabel) {
        this.mv.visitJumpInsn(167, finalLabel);
    }

    private void codeGenerateIfBlockEnd(Label tryEndLabel, Label finalLabel) {
        --this.tokenLocalVarIndex;
        this.mv.visitLabel(tryEndLabel);
        this.mv.visitVarInsn(58, 3);
        this.codeGeneratePopContext();
        this.mv.visitVarInsn(25, 3);
        this.mv.visitInsn(191);
        this.mv.visitLabel(finalLabel);
        this.codeGeneratePopContext();
    }

    private void codeGenerateIfToken(IfToken ifToken) {
        if (ifToken instanceof IfCmpToken) {
            this.mv.visitTypeInsn(187, "org/togglz/console/shade/jmte/token/IfCmpToken");
            this.mv.visitInsn(89);
            this.pushList(ifToken.getSegments());
            this.pushConstant(ifToken.getExpression());
            this.pushConstant(((IfCmpToken)ifToken).getOperand());
            this.mv.visitInsn(ifToken.isNegated() ? 4 : 3);
            this.mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/token/IfCmpToken", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V");
        } else {
            this.mv.visitTypeInsn(187, "org/togglz/console/shade/jmte/token/IfToken");
            this.mv.visitInsn(89);
            this.pushList(ifToken.getSegments());
            this.pushConstant(ifToken.getExpression());
            this.mv.visitInsn(ifToken.isNegated() ? 4 : 3);
            this.mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/token/IfToken", "<init>", "(Ljava/util/List;Ljava/lang/String;Z)V");
        }
        this.mv.visitVarInsn(58, this.tokenLocalVarIndex);
    }

    private void pushList(List<String> list) {
        this.mv.visitIntInsn(16, list.size());
        this.mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < list.size(); ++i) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, i);
            this.mv.visitLdcInsn(list.get(i));
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;");
    }

    private void codeGenerateIfBlockStart(IfToken ifToken, Label tryEndLabel, Label elseLabel) {
        Label tryStartLabel = new Label();
        this.mv.visitTryCatchBlock(tryStartLabel, tryEndLabel, tryEndLabel, null);
        this.codeGenerateIfToken(ifToken);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/TemplateContext", "push", "(Lcom/floreysoft/jmte/token/Token;)V");
        this.mv.visitLabel(tryStartLabel);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/IfToken", "evaluate", "(Lcom/floreysoft/jmte/TemplateContext;)Ljava/lang/Object;");
        this.mv.visitTypeInsn(192, "java/lang/Boolean");
        this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        this.mv.visitJumpInsn(153, elseLabel);
        ++this.tokenLocalVarIndex;
    }

    private void codeGeneratePopContext() {
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/TemplateContext", "pop", "()Lcom/floreysoft/jmte/token/Token;");
        this.mv.visitInsn(87);
    }

    private void codeGenerateForeachBlockEnd(Label loopStart, Label loopEnd, Label tryEndLabel) {
        --this.tokenLocalVarIndex;
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "isLast", "()Z");
        this.mv.visitJumpInsn(154, loopEnd);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "getSeparator", "()Ljava/lang/String;");
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.mv.visitInsn(87);
        this.mv.visitLabel(loopEnd);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "iterator", "()Ljava/util/Iterator;");
        this.mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
        this.mv.visitJumpInsn(154, loopStart);
        Label noExceptionFinallyLabel = new Label();
        this.mv.visitJumpInsn(167, noExceptionFinallyLabel);
        this.mv.visitLabel(tryEndLabel);
        this.mv.visitVarInsn(58, 3);
        this.codeGenerateExitScope();
        this.codeGeneratePopContext();
        this.mv.visitVarInsn(25, 3);
        this.mv.visitInsn(191);
        this.mv.visitLabel(noExceptionFinallyLabel);
        this.codeGenerateExitScope();
        this.codeGeneratePopContext();
    }

    private void codeGenerateForeachToken(ForEachToken feToken) {
        this.mv.visitTypeInsn(187, "org/togglz/console/shade/jmte/token/ForEachToken");
        this.mv.visitInsn(89);
        this.pushList(feToken.getSegments());
        this.pushConstant(feToken.getExpression());
        this.pushConstant(feToken.getVarName());
        this.pushConstant(feToken.getSeparator());
        this.mv.visitMethodInsn(183, "org/togglz/console/shade/jmte/token/ForEachToken", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
        this.mv.visitVarInsn(58, this.tokenLocalVarIndex);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "evaluate", "(Lcom/floreysoft/jmte/TemplateContext;)Ljava/lang/Object;");
        this.mv.visitTypeInsn(192, "java/lang/Iterable");
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "setIterable", "(Ljava/lang/Iterable;)V");
    }

    private void codeGenerateForeachBlockStart(ForEachToken feToken, Label loopStart, Label loopEnd, Label tryEndLabel) {
        Label tryStartLabel = new Label();
        this.mv.visitTryCatchBlock(tryStartLabel, tryEndLabel, tryEndLabel, null);
        this.codeGenerateForeachToken(feToken);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitFieldInsn(180, "org/togglz/console/shade/jmte/TemplateContext", "model", "Lorg/togglz/console/shade/jmte/ScopedMap;");
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/ScopedMap", "enterScope", "()V");
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/TemplateContext", "push", "(Lcom/floreysoft/jmte/token/Token;)V");
        this.mv.visitLabel(tryStartLabel);
        this.mv.visitJumpInsn(167, loopEnd);
        this.mv.visitLabel(loopStart);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitFieldInsn(180, "org/togglz/console/shade/jmte/TemplateContext", "model", "Lorg/togglz/console/shade/jmte/ScopedMap;");
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "getVarName", "()Ljava/lang/String;");
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/token/ForEachToken", "advance", "()Ljava/lang/Object;");
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/ScopedMap", "put", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        this.mv.visitInsn(87);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, this.tokenLocalVarIndex);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitFieldInsn(180, "org/togglz/console/shade/jmte/TemplateContext", "model", "Lorg/togglz/console/shade/jmte/ScopedMap;");
        this.mv.visitMethodInsn(182, this.className, "addSpecialVariables", "(Lcom/floreysoft/jmte/token/ForEachToken;Ljava/util/Map;)V");
        ++this.tokenLocalVarIndex;
    }

    private void codeGenerateExitScope() {
        this.mv.visitVarInsn(25, 1);
        this.mv.visitFieldInsn(180, "org/togglz/console/shade/jmte/TemplateContext", "model", "Lorg/togglz/console/shade/jmte/ScopedMap;");
        this.mv.visitMethodInsn(182, "org/togglz/console/shade/jmte/ScopedMap", "exitScope", "()V");
    }

    private static class DelegatingClassLoader
    extends ClassLoader {
        private final ClassLoader parentClassLoader;

        public DelegatingClassLoader(ClassLoader parentClassLoader) {
            this.parentClassLoader = parentClassLoader;
        }

        public Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.parentClassLoader.loadClass(name);
        }
    }
}

