/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.googlecloudspanner.repository;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import jakarta.inject.Inject;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.googlecloudspanner.repository.DefaultSpannerFeatureStateDao;
import org.togglz.googlecloudspanner.repository.SpannerFeatureStateDao;

public class SpannerStateRepository
implements StateRepository {
    private final SpannerFeatureStateDao dao;
    private final DatabaseClient databaseClient;

    @Inject
    public SpannerStateRepository(DatabaseClient databaseClient) {
        this(databaseClient, new DefaultSpannerFeatureStateDao());
    }

    @Inject
    public SpannerStateRepository(DatabaseClient databaseClient, SpannerFeatureStateDao dao) {
        this.databaseClient = databaseClient;
        this.dao = dao;
    }

    public void removeFeatureState(Feature feature) {
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(tx -> {
            this.dao.delete(feature.name(), tx);
            return null;
        });
    }

    public boolean existsFeatureState(Feature feature) {
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction();){
            boolean bl = this.dao.select(feature, tx).isPresent();
            return bl;
        }
    }

    public FeatureState getFeatureState(Feature feature) {
        try (ReadOnlyTransaction tx = this.databaseClient.readOnlyTransaction();){
            FeatureState featureState = this.dao.select(feature, tx).orElse(null);
            return featureState;
        }
    }

    public void setFeatureState(FeatureState featureState) {
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(tx -> {
            this.dao.upsert(featureState, tx);
            return null;
        });
    }
}

